/*
* cxtest - cxtest version 0.1
* Copyright (C)  2005 Seo, Won Ho. All rights reserved.
*
* This file is a part of the cxtest (https://sourceforge.net/projects/cxtest).
* The use and distribution terms for this software are covered by the
* Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
* which can be found in the file epl-v10.html at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef __CXSTDLIB_H__
#define __CXSTDLIB_H__

#ifdef	__cplusplus
extern "C" {
#endif

#ifndef NULL
#define	NULL	0
#endif

char*	cx_strcpy(char *dst, const char *src);
char*	cx_strncpy(char *dst, const char *src,unsigned int size);
char*	cx_strcat(char *dst, const char *src);
char*	cx_strncat(char *dst, const char *src,unsigned int count);
int		cx_strlen(const char *str);
int		cx_strcmp(const char *s1, const char *s2);
char*	cx_itoa(int v,char *string,int r);
int		cx_memcmp(const void *s1, const void *s2,unsigned int count);

/*	#define NO_STDLIB*/
#ifdef	NO_STDLIB
	extern void cx_print(const char *string);
#else
    #include<stdlib.h>
    #define cx_free        free
    #define cx_malloc  malloc
    #define cx_itoa        _itoa
    #define cx_atoi		_atoi
    #include <string.h>
    #define cx_memset memset

#endif

/*	#define NO_STDIO_PRINTF*/
#ifdef	NO_STDIO_PRINTF
	extern void cx_print(const char *string);
#else
	#include<stdio.h>
	#define cx_print printf
#endif
    
#ifdef	__cplusplus
}
#endif

#endif /* __CXSTDLIB_H__ */