/*
* cxtest - cxtest version 0.1
* Copyright (C)  2005 Seo, Won Ho. All rights reserved.
*
* This file is a part of the cxtest (https://sourceforge.net/projects/cxtest).
* The use and distribution terms for this software are covered by the
* Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
* which can be found in the file epl-v10.html at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef __CXTESTFIXTURE_H__
#define __CXTESTFIXTURE_H__

typedef void(*PFNTEST)(ITest* pme);

typedef struct __ITestFixture	ITestFixture;

typedef struct __ITestFixtureVtbl ITestFixtureVtbl;

struct __ITestFixtureVtbl {
    uint32 (* addRef) (ITestFixture* pobj);
    uint32 (* release) (ITestFixture* pobj);
    CXRESULT (*queryInterface)(ITestFixture* pobj, CXCLSID clsid, void ** ppNew);
    CXRESULT (*init)(ITestFixture* pobj, char* name, PFNTEST test);
    char*	(*name)(ITestFixture* po);
    PFNTEST (*test)(ITestFixture* po);    
};

#define ITestFixture_addRef(pobj)         (*(ITestFixtureVtbl**)pobj)->addRef(pobj)
#define ITestFixture_release(pobj)         (*(ITestFixtureVtbl**)pobj)->release(pobj)
#define ITestFixture_queryInterface(po,id,ppn) (*((ITestFixtureVtbl**)po))->queryInterface(po,id,ppn)

#define ITestFixture_init(pobj, name, test) (*((ITestFixtureVtbl**)pobj))->init(pobj, name, (PFNTEST)test)
#define ITestFixture_name(p) (*(ITestFixtureVtbl**)p)->name(p)
#define ITestFixture_test(p) (*(ITestFixtureVtbl**)p)->test(p)


CXRESULT 
_ITestFixture_new(ITestFixture** ppobj);

#endif //  __CXTESTFIXTURE_H__

