/*
* cxtest - cxtest version 0.1
* Copyright (C)  2005 Seo, Won Ho. All rights reserved.
*
* This file is a part of the cxtest (https://sourceforge.net/projects/cxtest).
* The use and distribution terms for this software are covered by the
* Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
* which can be found in the file epl-v10.html at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef	__CXTESTREPEAT_H__
#define	__CXTESTREPEAT_H__

//#include "acttestresult.h"

typedef struct __ITestRepeat	ITestRepeat;

typedef struct __ITestRepeatVtbl ITestRepeatVtbl;

struct __ITestRepeatVtbl
{
    uint32 (* addRef) (ITestRepeat* pobj);
    uint32 (* release) (ITestRepeat* pobj);
    CXRESULT (*queryInterface)(ITestRepeat* pobj, CXCLSID clsid, void ** ppNew);    
    char* (*name)(ITestRepeat* pobj);
    void (*run)(ITestRepeat* pobj, ITestResult* pResult);
    int  (*countTestCases)(ITestRepeat* pobj);
    int  (*getChildTestCount)(ITestRepeat* pobj);
    ITest* (*getChildTestAt)(ITestRepeat* pobj, int index);
    ITest* (*findTest)(ITestRepeat* pobj, char *name);    

    CXRESULT(*init)(ITestRepeat* pobj, ITest* test, int timesRepeat);
};

#define ITestRepeat_addRef(pobj)         (*(ITestRepeatVtbl**)pobj)->addRef(pobj)
#define ITestRepeat_release(pobj)         (*(ITestRepeatVtbl**)pobj)->release(pobj)
#define ITestRepeat_queryInterface(po,id,ppn) (*((ITestRepeatVtbl**)po))->queryInterface(po,id,ppn)

#define ITestRepeat_name(pobj)           (*(ITestRepeatVtbl**)pobj)->name(pobj)
#define ITestRepeat_run(pobj,r)          (*(ITestRepeatVtbl**)pobj)->run(pobj,r)
#define ITestRepeat_countTestExCases(pobj) (*(ITestRepeatVtbl**)pobj)->countTestCases(pobj)
#define ITestRepeat_getChildTestCount(pobj) (*(ITestRepeatVtbl**)pobj)->getChildTestCount(pobj)
#define ITestRepeat_getChildTestAt(pobj,i) (*(ITestRepeatVtbl**)pobj)->getChildTestAt(pobj,i)
#define ITestRepeat_findTest(pobj,n) (*(ITestRepeatVtbl**)pobj)->findTest(pobj,n)

#define ITestRepeat_init(pobj, test, times) (*(ITestRepeatVtbl**)pobj)->init(pobj,test, times)

CXRESULT 
_ITestRepeat_new(ITestRepeat** ppobj);

#endif /* __CXTESTREPEAT_H__ */

