/*
* cxtest - cxtest version 0.1
* Copyright (C)  2005 Seo, Won Ho. All rights reserved.
*
* This file is a part of the cxtest (https://sourceforge.net/projects/cxtest).
* The use and distribution terms for this software are covered by the
* Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
* which can be found in the file epl-v10.html at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef __CXTESTRESULT_H__
#define __CXTESTRESULT_H__
/**
@file acttestresult.h
*/

#ifdef	__cplusplus
extern "C" {
#endif

typedef struct __ITest				ITest;
typedef struct __ITestListener		ITestListener;

typedef struct __ITestResult		ITestResult;

typedef struct __ITestResultVtbl ITestResultVtbl;

struct __ITestResultVtbl 
{
    uint32 (*addRef)(ITestResult* pme);
    uint32 (* release) (ITestResult* pobj);
    CXRESULT (*queryInterface)(ITestResult* pobj, CXCLSID clsid, void ** ppNew);
    
	CXRESULT (*init)(ITestResult* pme,ITestListener* listner);
	void (*startTest)(ITestResult* pme,ITest* test);
	void (*endTest)(ITestResult* pme,ITest* test);
	void (*addFailure)(ITestResult* pme,ITest* test,const char* msg,int line,const char* file);

       int (*getFailureCount)(ITestResult* pme);
       int (*getRunCount)(ITestResult* pme);
};

#define ITestResult_addRef(po)              (*(ITestResultVtbl**)po)->addRef(po)
#define ITestResult_release(po)              (*(ITestResultVtbl**)po)->release(po)
#define ITestResult_queryInterface(pobj,id,ppn) (*(ITestResultVtbl**)pobj)->queryInterface(pobj,id,ppn)

#define ITestResult_init(po,listener)       (*(ITestResultVtbl**)po)->init(po,listener)
#define ITestResult_startTest(po,test)      (*(ITestResultVtbl**)po)->startTest(po,test)
#define ITestResult_endTest(po,test)        (*(ITestResultVtbl**)po)->endTest(po,test)
#define ITestResult_addFailure(po,t,m,l,f)  (*(ITestResultVtbl**)po)->addFailure(po,t,m,l,f)

#define ITestResult_getFailureCount(pobj) (*(ITestResultVtbl**)pobj)->getFailureCount(pobj)
#define ITestResult_getRunCount(pobj) (*(ITestResultVtbl**)pobj)->getRunCount(pobj)

CXRESULT 
_ITestResult_new(ITestResult** ppobj);

#ifdef	__cplusplus
}
#endif

#endif /* __CXTESTRESULT_H__ */
