/*
* cxtest - cxtest version 0.1
* Copyright (C)  2005 Seo, Won Ho. All rights reserved.
*
* This file is a part of the cxtest (https://sourceforge.net/projects/cxtest).
* The use and distribution terms for this software are covered by the
* Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
* which can be found in the file epl-v10.html at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#include "cx.h"
#include "cxstdlib.h"
#include "cxassertimpl.h"

void cx_assertImplementationInt(ITest *pme, int expected,int actual, long line, const char *file)
{
	char buffer[32];	/*"exp -2147483647 was -2147483647"*/
	char numbuf[12];	/*32bit int decimal maximum column is 11 (-2147483647~2147483647)*/

	cx_strcpy(buffer, "exp ");

	{	cx_itoa(expected, numbuf, 10);
		cx_strncat(buffer, numbuf, 11);	}

	cx_strcat(buffer, " was ");

	{	cx_itoa(actual, numbuf, 10);
		cx_strncat(buffer, numbuf, 11);	}

	cx_addFailure(pme, buffer, line, file);
}

void cx_assertImplementationCStr(ITest *pme, const char *expected,const char *actual, long line, const char *file)
{
	char buffer[ASSERT_STRING_BUFFER_MAX];
	#define exp_cx_limit ((ASSERT_STRING_BUFFER_MAX-11-1)/2)/*	"exp'' was''" = 11 byte	*/
	int el;
	int al;

	if (expected) {
		el = cx_strlen(expected);
	} else {
		el = 4;
		expected = "null";
	}

	if (actual) {
		al = cx_strlen(actual);
	} else {
		al = 4;
		actual = "null";
	}
	if (el > exp_cx_limit) {
		if (al > exp_cx_limit) {
			al = exp_cx_limit;
			el = exp_cx_limit;
		} else {
			int w = exp_cx_limit + (exp_cx_limit - al);
			if (el > w) {
				el = w;
			}
		}
	} else {
		int w = exp_cx_limit + (exp_cx_limit - el);
		if (al > w) {
			al = w;
		}
	}
	cx_strcpy(buffer, "exp \"");
	cx_strncat(buffer, expected, el);
	cx_strcat(buffer, "\" was \"");
	cx_strncat(buffer, actual, al);
	cx_strcat(buffer, "\"");

	cx_addFailure(pme, buffer, line, file);
}
