#include "cx.h"
#include "cxtest.h"
#include "cxtestlist.h"

struct __ITestRunner {
    ITestRunnerVtbl *pvt;
    uint32 m_cRef;
    ITestList* m_lstTest__;
    ITestResult* m_piTestResult__;
	ITestListener* m_piTestListener__;
};

void 
_ITestRunner_ctor(ITestRunner* pme, ITestRunnerVtbl* pvt);

void 
_ITestRunner_initVtbl(ITestRunnerVtbl* pvt);

CXRESULT 
_ITestRunner_init(ITestRunner* pobj);

uint32 
_ITestRunner_addRef(ITestRunner* pobj);


uint32 
_ITestRunner_release(ITestRunner* pobj);


void 
_ITestRunner_dtor(ITestRunner* pme);


CXRESULT 
_ITestRunner_queryInterface(ITestRunner* pobj, CXCLSID clsid, void ** ppNew);


void 
_ITestRunner_start(ITestRunner* pme);


void 
_ITestRunner_addTest(ITestRunner* pme, ITest* test);


void 
_ITestRunner_runTest(ITestRunner* pMe);


void 
_ITestRunner_end(ITestRunner* pme);



CXRESULT 
ITestRunner_new(ITestRunner** ppobj)
{
    CXRESULT result;
    ITestRunner *pme;

    pme = cx_malloc(sizeof(ITestRunner)+sizeof(ITestRunnerVtbl));

    if(!pme)
    {
        return CX_E_NOMEMORY;
    }

    _ITestRunner_ctor(pme, (ITestRunnerVtbl*)(pme+1));    
    result = _ITestRunner_init(pme);
    if(!result)
    {
        *ppobj = pme;
    }
    else
    {
        _ITestRunner_dtor(pme);
        cx_free(pme);        
    }

    *ppobj = (ITestRunner*)pme;
    
    return result;
}

void 
_ITestRunner_ctor(ITestRunner* pme, ITestRunnerVtbl* pvt)
{
    pme->m_cRef = 1;

    if(pvt)
    {
        pme->pvt = pvt;
        _ITestRunner_initVtbl(pvt);
    }    
}


void 
_ITestRunner_initVtbl(ITestRunnerVtbl* pvt)
{
    pvt->addRef = _ITestRunner_addRef;
    pvt->release = _ITestRunner_release;
    pvt->queryInterface = _ITestRunner_queryInterface;

    pvt->start = _ITestRunner_start;
    pvt->addTest = _ITestRunner_addTest;
    pvt->runTest = _ITestRunner_runTest;
    pvt->end = _ITestRunner_end;
}


CXRESULT 
_ITestRunner_init(ITestRunner* pobj)
{
    ITestRunner * pme;
    pme = (ITestRunner *) pobj;

    ITestList_new( &pme->m_lstTest__);
    _ITestResult_new(&pme->m_piTestResult__);
    ITestListener_new(&pme->m_piTestListener__);

    return CX_S_OK;
}


uint32 
_ITestRunner_addRef(ITestRunner* pobj)
{
    ITestRunner* pme = (ITestRunner*) pobj;
    return ++pme->m_cRef;
}


uint32 
_ITestRunner_release(ITestRunner* pobj)
{
    ITestRunner* pme;
    uint32 cRef;

    pme = (ITestRunner*) pobj;

    cRef = --pme->m_cRef;

    if(cRef == 0)
    {        
        _ITestRunner_dtor(pme);
        cx_free(pme);
    }
    
    return cRef;
}


void 
_ITestRunner_dtor(ITestRunner* pme)
{
	if (pme->m_lstTest__)
		ITestList_release(pme->m_lstTest__);
	if (pme->m_piTestResult__)
		ITestResult_release(pme->m_piTestResult__);

    if(pme->m_piTestListener__)
    {
        ITestListener_release(pme->m_piTestListener__);
    }    
}


CXRESULT 
_ITestRunner_queryInterface(ITestRunner* pobj, CXCLSID clsid, void ** ppNew)
{
    CXRESULT result;

    result = CX_E_CLASSNOTSUPPORT;
    *ppNew = 0;

    if (clsid == CXCLSID_UNKNOWN ||
        clsid == CXCLSID_TESTRUNNER)
    {
        *ppNew = pobj;
        _ITestRunner_addRef(pobj);
        result = CX_S_OK;
    }
    
    return result;
}


void _ITestRunner_start(ITestRunner* pme)
{
    ITestResult_init(pme->m_piTestResult__, (ITestListener*) pme->m_piTestListener__);
}


void _ITestRunner_addTest(ITestRunner* pme, ITest* test)
{
    ITestList_addTail(pme->m_lstTest__, test);
}

void _ITestRunner_runTest(ITestRunner* pme)
{
    ITestNode* pNode;
    ITest* test;
    int nCount;
    int index;

    pNode = (ITestNode*) ITestList_getHeadPosition(pme->m_lstTest__);
    nCount = ITestList_getCount(pme->m_lstTest__);
    for(index = 0; index < nCount; index++)
    {
        test = (ITest*) ITestList_getNext(pme->m_lstTest__, &pNode);
        ITest_run(test, pme->m_piTestResult__);
    }
}


void _ITestRunner_end(ITestRunner* pme)
{
    int nFailureCount;
    int nRunCount;
    char buf[16];

    nFailureCount = ITestResult_getFailureCount(pme->m_piTestResult__);
    nRunCount = ITestResult_getRunCount(pme->m_piTestResult__);
    if (nFailureCount) {
        cx_print("\nrun ");
        cx_itoa(nRunCount, buf, 10);
        cx_print(buf);
        cx_print(" failures ");
        cx_itoa(nFailureCount, buf, 10);
        cx_print(buf);
        cx_print("\n");
    } else {
        cx_print("\nOK (");
        cx_itoa(nRunCount, buf, 10);
        cx_print(buf);
        cx_print(" tests)\n");
    }

}
