// actMfcTestRunner.cpp : Defines the initialization routines for the DLL.
//

#include "stdafx.h"
#include <afxdllx.h>

#include "resource.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


static AFX_EXTENSION_MODULE actMfcTestRunnerDLL = { NULL, NULL };

extern "C" int APIENTRY
DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID lpReserved)
{
	// Remove this if you use lpReserved
	UNREFERENCED_PARAMETER(lpReserved);

	if (dwReason == DLL_PROCESS_ATTACH)
	{
		TRACE0("actMfcTestRunner.DLL Initializing!\n");
		
		// Extension DLL one-time initialization
		if (!AfxInitExtensionModule(actMfcTestRunnerDLL, hInstance))
			return 0;

		// Insert this DLL into the resource chain
		// NOTE: If this Extension DLL is being implicitly linked to by
		//  an MFC Regular DLL (such as an ActiveX Control)
		//  instead of an MFC application, then you will want to
		//  remove this line from DllMain and put it in a separate
		//  function exported from this Extension DLL.  The Regular DLL
		//  that uses this Extension DLL should then explicitly call that
		//  function to initialize this Extension DLL.  Otherwise,
		//  the CDynLinkLibrary object will not be attached to the
		//  Regular DLL's resource chain, and serious problems will
		//  result.

		new CDynLinkLibrary(actMfcTestRunnerDLL);
	}
	else if (dwReason == DLL_PROCESS_DETACH)
	{
		TRACE0("actMfcTestRunner.DLL Terminating!\n");
		// Terminate the library before destructors are called
		AfxTermExtensionModule(actMfcTestRunnerDLL);
	}
	return 1;   // ok
}

#include "actMfcTestRunnerDlg.h"


/*
void __declspec(dllexport) test ()
{
	actMfcTestRunnerDlg dlg;

	dlg.DoModal();
}
*/

#include "actconfig.h"
#include "actstdlib.h"
#include "actTest.h"
#include "actTestListener.h"
#include "actTestResult.h"
#include "actMfcTestRunner.h"

static void __ITestRunner_startTest(ITestListener* self,ITest* test);
static void __ITestRunner_endTest(ITestListener* self,ITest* test);
static void __ITestRunner_addFailure(ITestListener* self,ITest* test,char* msg,int line,char* file);


static const ITestListenerVtbl g_ITestListenerVtbl = {
	(TestListnerStartTestCallBack)	__ITestRunner_startTest,
	(TestListnerEndTestCallBack)	__ITestRunner_endTest,
	(TestListnerAddFailureCallBack)	__ITestRunner_addFailure,
};

static IMfcTestRunnerVtbl g_ITestRunnerVtbl = {
	IMfcTestRunner_start,
	IMfcTestRunner_addTest,
	IMfcTestRunner_run,
	IMfcTestRunner_end,
};

static const ITestListener testrunner_ = {
	(ITestListenerVtbl*)&g_ITestListenerVtbl,
};

static ITestResult result_;
static ITest* loc_pRootTest__;

static void __ITestRunner_setRootTest(ITest* pTest)
{
	loc_pRootTest__	= pTest;
}

static ITest*  __ITestRunner_getRootTest()
{
	return loc_pRootTest__;
}

static void __ITestRunner_startTest(ITestListener* self,ITest* test)
{
	ACT_print(".");
}

static void __ITestRunner_endTest(ITestListener* self,ITest* test)
{

}

static void __ITestRunner_addFailure(ITestListener* self,ITest* test,char* msg,int line,char* file)
{
	ACT_print("\n");
	ACT_print(ITest_name(loc_pRootTest__));
	ACT_print(".");
	ACT_print(ITest_name(test));
	{
		char buf[16];
		ACT_print(" (");
		ACT_print(file);
		ACT_print(" ");
		ACT_itoa(line, buf, 10);
		ACT_print(buf);
		ACT_print(") ");
	}
	ACT_print(msg);
	ACT_print("\n");
}


void ACTAPI IMfcTestRunner_start(IMfcTestRunner* po)
{
	ITestResult_Ctor(&result_,NULL);
	ITestResult_init(&result_, (ITestListener*) &testrunner_);
}

void ACTAPI IMfcTestRunner_addTest(IMfcTestRunner* po, ITest* test)
{
	__ITestRunner_setRootTest(test);
	
	ITest_run(test, &result_);	
}

void ACTAPI IMfcTestRunner_run(IMfcTestRunner* po)
{
	/* nothing*/	
}
void ACTAPI IMfcTestRunner_end(IMfcTestRunner*po)
{
	char buf[16];
	if (result_.failureCount) {
		ACT_print("\nrun ");
		ACT_itoa(result_.runCount, buf, 10);
		ACT_print(buf);
		ACT_print(" failures ");
		ACT_itoa(result_.failureCount, buf, 10);
		ACT_print(buf);
		ACT_print("\n");
	} else {
		ACT_print("\nOK (");
		ACT_itoa(result_.runCount, buf, 10);
		ACT_print(buf);
		ACT_print(" tests)\n");
	}
	
}

IMfcTestRunner* IMfcTestRunner_Ctor(IMfcTestRunner* pme)
{
	pme->pvt = &g_ITestRunnerVtbl;
	return pme;
}



