#include "act.h"
#include "actMockTestCase.h"

static void setUp(void)
{
}

static void tearDown(void)
{
}

static void testName(void)
{
	ITestCase* pMockTestCase = actMockTestCase_case();
	ACT_TEST_ASSERT_EQUAL_STRING("actMockTestCase", ITest_name(pMockTestCase));
}

static void testCountTestCases(void)
{
	ITestCase* pMockTestCase = actMockTestCase_case();
	ACT_TEST_ASSERT_EQUAL_INT(1, ITest_countTestCases(pMockTestCase));
}

static void success_runTest(void)
{
}

static void testSuccess(void)
{
	ITestCase tcase;
	ITestResult result;

	ITestCase_Ctor(&tcase,"success",NULL,NULL,success_runTest);

	ITestResult_Ctor(&result,NULL);

	ITest_run(&tcase, &result);

	ACT_TEST_ASSERT_EQUAL_INT(1, result.runCount);
	ACT_TEST_ASSERT_EQUAL_INT(0, result.failureCount);
}

static void failure_runTest(void)
{
	ACT_TEST_FAIL("");
}

static void testFailure(void)
{
	ITestCase tcase;
	ITestResult result;

	ITestCase_Ctor(&tcase,"failure",NULL,NULL,failure_runTest);

	ITestResult_Ctor(&result,NULL);

	ITest_run(&tcase, &result);	

	ACT_TEST_ASSERT_EQUAL_INT(1, result.runCount);
	ACT_TEST_ASSERT_EQUAL_INT(1, result.failureCount);
}
 
ITest* actTestCaseTest_tests(void)
{
	ACT_UNIT_TESTCALLER_CTOR(TestCaseTest,"TestCaseTest",setUp,tearDown);
		ACT_UNIT_ADD_FIXTURE(&TestCaseTest,"testName",testName);
		ACT_UNIT_ADD_FIXTURE(&TestCaseTest,"testCountTestCases",testCountTestCases);
		ACT_UNIT_ADD_FIXTURE(&TestCaseTest,"testSuccess",testSuccess);
		ACT_UNIT_ADD_FIXTURE(&TestCaseTest,"testFailure",testFailure);

	return (ITest* )&TestCaseTest;
}
