#include "act.h"
#include "person.h"

PersonRef personRef;

static void setUp(void)
{
	personRef = Person_personWithName("test tarou");
}

static void tearDown(void)
{
	Person_dealloc(personRef);
}

static void testfullname(void)
{
	ACT_TEST_ASSERT_EQUAL_STRING("test tarou", Person_fullName(personRef));
}

static void testfirstname(void)
{
	ACT_TEST_ASSERT_EQUAL_STRING("test", Person_firstName(personRef));
}

static void testlastname(void)
{
	ACT_TEST_ASSERT_EQUAL_STRING("tarou", Person_lastName(personRef));
}

static void testsetfullname(void)
{
	Person_setFullName(personRef, "sample hanako");

	ACT_TEST_ASSERT_EQUAL_STRING("sample hanako", Person_fullName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("sample", Person_firstName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("hanako", Person_lastName(personRef));
}

static void testsetfirstname(void)
{
	Person_setFirstName(personRef, "sample");

	ACT_TEST_ASSERT_EQUAL_STRING("sample tarou", Person_fullName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("sample", Person_firstName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("tarou", Person_lastName(personRef));
}

static void testsetlastname(void)
{
	Person_setLastName(personRef, "hanako");

	ACT_TEST_ASSERT_EQUAL_STRING("test hanako", Person_fullName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("test", Person_firstName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("hanako", Person_lastName(personRef));
}

static void testnullcharfullname(void)
{
	Person_setFullName(personRef, "");

	ACT_TEST_ASSERT_EQUAL_STRING("", Person_fullName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("", Person_firstName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("", Person_lastName(personRef));
}

static void testnullpointerfullname(void)
{
	Person_setFullName(personRef, NULL);

	ACT_TEST_ASSERT_NULL(Person_fullName(personRef));
	ACT_TEST_ASSERT_NULL(Person_firstName(personRef));
	ACT_TEST_ASSERT_NULL(Person_lastName(personRef));
}

static void testnosepfullname(void)
{
	Person_setFullName(personRef, "sample");

	ACT_TEST_ASSERT_EQUAL_STRING("sample", Person_fullName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("sample", Person_firstName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("", Person_lastName(personRef));

	Person_setLastName(personRef, "tarou");
	ACT_TEST_ASSERT_EQUAL_STRING("sample tarou", Person_fullName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("sample", Person_firstName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("tarou", Person_lastName(personRef));

	Person_setFirstName(personRef, "test");
	ACT_TEST_ASSERT_EQUAL_STRING("test tarou", Person_fullName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("test", Person_firstName(personRef));
	ACT_TEST_ASSERT_EQUAL_STRING("tarou", Person_lastName(personRef));
}

ITest* PersonTest_tests(void)
{
/*
	EMB_UNIT_TESTFIXTURES(fixtures) {
		new_TestFixture("testfullname",testfullname),
		new_TestFixture("testfirstname",testfirstname),
		new_TestFixture("testlastname",testlastname),
		new_TestFixture("testsetfullname",testsetfullname),
		new_TestFixture("testsetfirstname",testsetfirstname),
		new_TestFixture("testsetlastname",testsetlastname),
		new_TestFixture("testnullcharfullname",testnullcharfullname),
		new_TestFixture("testnullpointerfullname",testnullpointerfullname),
		new_TestFixture("testnosepfullname",testnosepfullname),
	};
	EMB_UNIT_TESTCALLER(PersonTest,"PersonTest",setUp,tearDown,fixtures);
*/
	static ITestCaller PersonTest;
	static ITestFixture fixture1;
	static ITestFixture fixture2;
	static ITestFixture fixture3;
	static ITestFixture fixture4;
	static ITestFixture fixture5;
	static ITestFixture fixture6;
	static ITestFixture fixture7;
	//static ITestFixture fixture8;
	//static ITestFixture fixture9;

	ITestCaller_Ctor(&PersonTest,"PersonTest",setUp,tearDown);

		ITestFixture_Ctor(&fixture1,"testfullname",testfullname);
		ITestFixture_Ctor(&fixture2,"testfirstname",testfirstname);
		ITestFixture_Ctor(&fixture3,"testlastname",testlastname);
		ITestFixture_Ctor(&fixture4,"testsetfullname",testsetfullname);
		ITestFixture_Ctor(&fixture5,"testsetfirstname",testsetfirstname);
		ITestFixture_Ctor(&fixture6,"testsetlastname",testsetlastname);
		ITestFixture_Ctor(&fixture7,"testnullcharfullname",testnullcharfullname);
		//ITestFixture_Ctor(&fixture8,"testnullpointerfullname",testnullpointerfullname);
		//ITestFixture_Ctor(&fixture9,"testnosepfullname",testnosepfullname);

	ITestCaller_AddTestFixture(&PersonTest,&fixture1);
	ITestCaller_AddTestFixture(&PersonTest,&fixture2);
	ITestCaller_AddTestFixture(&PersonTest,&fixture3);
	ITestCaller_AddTestFixture(&PersonTest,&fixture4);
	ITestCaller_AddTestFixture(&PersonTest,&fixture5);
	ITestCaller_AddTestFixture(&PersonTest,&fixture6);
	ITestCaller_AddTestFixture(&PersonTest,&fixture7);
	//ITestCaller_AddTestFixture(&PersonTest,&fixture8);
	//ITestCaller_AddTestFixture(&PersonTest,&fixture9);
	{
		static ITestFixture fixture8;
		ITestFixture_Ctor(&fixture8,"testnullpointerfullname",testnullpointerfullname);
		ITestCaller_AddTestFixture(&PersonTest,&fixture8);
	}
	{
		static ITestFixture fixture8;
		ITestFixture_Ctor(&fixture8,"testnosepfullname",testnosepfullname);
		ITestCaller_AddTestFixture(&PersonTest,&fixture8);
	}



	return (ITest*)&PersonTest;
}
