
#include "actConfig.h"
#include "actStdLib.h"
#include "actTest.h"
#include "actTestCase.h"
#include "actTestCaller.h"

static char* __ITestFixture_name(ITestFixture* pme);
static PFNTEST  __ITestFixture_test(ITestFixture* pme);

static char*	__ITestCaller_name(ITestCaller* pme);
static void		__ITestCaller_run(ITestCaller* pme,ITestResult* result);
static int		__ITestCaller_countTestCases(ITestCaller* pme);
static void		__ITestCaller_AddTestFixture(ITestCaller* pme, ITestFixture* pFixture);

static ITestFixtureVtbl g_ITestFixtureVtbl = {
	__ITestFixture_name,
	__ITestFixture_test,
};


static const ITestCallerVtbl g_ITestCallerVtbl = {
	(PFNTestName)		__ITestCaller_name,
	(PFNTestRun)		__ITestCaller_run,
	(PFNCountTestCases) __ITestCaller_countTestCases,
	__ITestCaller_AddTestFixture,
};

// 
// ITestFixture Implementation
//


static char* __ITestFixture_name(ITestFixture* pme)
{
	return pme->name;
}

static PFNTEST  __ITestFixture_test(ITestFixture* pme)
{
	return pme->test;
}


ITestFixture* ITestFixture_Ctor(ITestFixture* pme, char* name, PFNTEST test)
{
	pme->pvt = &g_ITestFixtureVtbl;
	ACT_strncpy(pme->name, name,TEST_NAME_STRING_BUFFER_MAX);
	pme->test = test;

	return pme;
}

// 
// ITestCaller Implementation
//
static char* __ITestCaller_name(ITestCaller* pme)
{
	return pme->name;
}

static void __ITestCaller_run(ITestCaller* pme,ITestResult* result)
{
	ITestFixture* pITestFixture;
	int i;

	ITestCase cs;
	ITestCase_Ctor(&cs,"",NULL,NULL,NULL);

	cs.setUp= pme->setUp;
	cs.tearDown	= pme->tearDown;

	for (i=0; i<pme->numberOfFixtuers; i++) {
		pITestFixture =  pme->fixtures[i];
		ACT_strncpy (cs.name, ITestFixture_name(pITestFixture), TEST_NAME_STRING_BUFFER_MAX);
		cs.runTest	= ITestFixture_test(pITestFixture);
		/*run test*/
		ITest_run(&cs,result);
	}
}

static int __ITestCaller_countTestCases(ITestCaller* pme)
{
	return pme->numberOfFixtuers;
}

static void __ITestCaller_AddTestFixture(ITestCaller* pme, ITestFixture* pFixture)
{
	pme->fixtures[pme->numberOfFixtuers] = pFixture;
	pme->numberOfFixtuers++;
}

ITestCaller* ITestCaller_Ctor(ITestCaller* pme, char * name, PFNSETUP setup, PFNTEARDWON tdw)
{
	pme->pvt = (ITestCallerVtbl*)&g_ITestCallerVtbl;
	ACT_strncpy(pme->name,name, TEST_NAME_STRING_BUFFER_MAX);
	pme->setUp = setup;
	pme->tearDown = tdw;
	pme->numberOfFixtuers = 0;

	return pme;
}