#include "act.h"

static void setUp(void)
{
}

static void tearDown(void)
{
}

static void testOneFixture(void)
{
	/*
	TestFixture	fixtures[] = {
		new_TestFixture(NULL,NULL),
	};
	TestCaller caller = new_TestCaller(NULL,NULL,NULL,1,fixtures);
	TestResult result = new_TestResult(NULL);

	caller.isa->run(&caller,&result);
	*/

	
	static ITestCaller caller;
	static ITestResult result;
	
	ITestCaller_Ctor(&caller, "", NULL, NULL);
	ITestResult_Ctor(&result, NULL);
	{
		static ITestFixture fixture;
		ITestFixture_Ctor(&fixture,"",NULL);
		ITestCaller_AddTestFixture(&caller, &fixture);
	}

	ITest_run (&caller,&result);

	ACT_TEST_ASSERT_EQUAL_INT(1, result.runCount);
	ACT_TEST_ASSERT_EQUAL_INT(1, ITest_countTestCases(&caller));
}

static void testMoreThanOne(void)
{
	static ITestCaller caller;
	static ITestResult result;

	ITestCaller_Ctor(&caller, "", NULL, NULL);
	ITestResult_Ctor(&result, NULL);

	{
		static ITestFixture fixture;
		ITestFixture_Ctor(&fixture, "", NULL);
		ITestCaller_AddTestFixture(&caller, &fixture);
	}
	{
		static ITestFixture fixture;
		ITestFixture_Ctor(&fixture, "", NULL);
		ITestCaller_AddTestFixture(&caller, &fixture);
	}
	{
		static ITestFixture fixture;
		ITestFixture_Ctor(&fixture, "", NULL);
		ITestCaller_AddTestFixture(&caller, &fixture);
	}
	{
		static ITestFixture fixture;
		ITestFixture_Ctor(&fixture, "", NULL);
		ITestCaller_AddTestFixture(&caller, &fixture);
	}
	{
		static ITestFixture fixture;
		ITestFixture_Ctor(&fixture, "", NULL);
		ITestCaller_AddTestFixture(&caller, &fixture);
	}
	ITest_run(&caller, &result);

	ACT_TEST_ASSERT_EQUAL_INT(5, result.runCount);
	ACT_TEST_ASSERT_EQUAL_INT(5, ITest_countTestCases(&caller));
}

static void testZeroFixture(void)
{
	static ITestCaller caller;
	static ITestResult result;

	ITestCaller_Ctor(&caller, "", NULL, NULL);
	ITestResult_Ctor(&result, NULL);

	ITest_run(&caller, &result);


	ACT_TEST_ASSERT_EQUAL_INT(0, result.runCount);
	ACT_TEST_ASSERT_EQUAL_INT(0, ITest_countTestCases(&caller));
}

ITest* TestCallerTest_tests(void)
{
	ACT_UNIT_TESTCALLER_CTOR(TestCallerTest,"TestCallerTest",setUp,tearDown);
		ACT_UNIT_ADD_FIXTURE(&TestCallerTest,"testOneFixture",testOneFixture);
		ACT_UNIT_ADD_FIXTURE(&TestCallerTest,"testMoreThanOne",testMoreThanOne);
		ACT_UNIT_ADD_FIXTURE(&TestCallerTest,"testZeroFixture",testZeroFixture);

	return (ITest*)&TestCallerTest;
}
