#ifndef	__ACTHELPERMACRO_H__
#define	__ACTHELPERMACRO_H__

#define ACT_UNIT_TESTCASE(ca,name,sup,tdw,run) \
	static ITestCase ca;\
	ITestCase_Ctor(&ca,name,sup,tdw,run)

#define ACT_TESTCASE_NEW(pTestCase,name,sup,tdw,run) \
    ITestCase* pTestCase;\
    pTestCase = ITestCase_New(name,sup,tdw,run)

#ifdef __ACTTESTSUITE_H__
#define ACT_UNIT_TESTSUITE(su,name,array) \
	static ITestSuite	su; \
	ITestSuite_Ctor(&su, name,sizeof(array)/sizeof(array[0]),(ITest**)array)
#endif

#define ACT_UNIT_TESTS(pTestArray) \
	static ITest* const pTestArray[] = 

#define ACT_UNIT_ADD_TEST(pTest) \
				(ITest*)	pTest

#ifdef __ACTTESTCALLER_H__
#define ACT_UNIT_TESTCALLER(caller,name,sup,tdw,fixtures) \
	static ITestCaller caller; \
	ITestCaller_Ctor(&caller, name,sup,tdw,sizeof(fixtures)/sizeof(fixtures[0]),(ITestFixture*)fixtures)
#endif

#define ACT_UNIT_TESTFIXTURES(fixtures) \
	static const ITestFixture	fixtures[] = 

#ifdef __ACTREPEATEDTEST_H__
#define ACT_UNIT_IREPEATEDTEST(repeater,test,tmrp) \
	static IRepeatedTest	repeater; \
	IRepeatedTest_Ctor(&repeater,test,tmrp)
#endif

///
/// ITestCaller_Ctor
/// 
#define ACT_UNIT_TESTCALLER_CTOR(caller_, name_, sup, tdw) \
	static ITestCaller caller_;\
	ITestCaller_Ctor(&caller_,name_,sup,tdw)

#define ACT_TESTCALLER_NEW(caller_, name_, sup, tdw) \
    ITestCaller* caller_; \
    caller_ = ITestCaller_New(name_,sup,tdw)

///
/// ITestCaller_AddTestFixture 
///
#define ACT_UNIT_ADD_FIXTURE(pCaller_, name_, pTest_) \
do { \
	static ITestFixture fixture; \
	ITestFixture_Ctor(&fixture,name_,pTest_);\
	ITestCaller_AddTestFixture(pCaller_, &fixture);\
} while(0)

#define ACT_ADD_FIXTURE(pCaller_, name_, pfnTest_) \
    ITestCaller_AddTestFixture(pCaller_, ITestFixture_New(name_, pfnTest_))

#endif/*__ACTHELPERMACRO_H__*/

