
#include "actConfig.h"
#include "actComDef.h"
#include "actStdLib.h"
#include "actTest.h"
#include "actTestCase.h"

#include "actTestFixture.h"
#include "actTestFixtureList.h"
#include "actTestCaller.h"
#include "actTestCaller_private.h"

#if 0
static char* __ITestFixture_name(ITestFixture* pme);
static PFNTEST  __ITestFixture_test(ITestFixture* pme);


static ITestFixtureVtbl g_ITestFixtureVtbl = {
	__ITestFixture_name,
	__ITestFixture_test,
};
#endif

static const ITestCallerVtbl g_ITestCallerVtbl = {
    (PFNTestDelete)     __ITestCaller_Delete,
	(PFNTestName)		__ITestCaller_name,
	(PFNTestRun)		__ITestCaller_run,
	(PFNCountTestCases) __ITestCaller_countTestCases,
	__ITestCaller_AddTestFixture,
};

#if 0
// 
// ITestFixture Implementation
//


static char* __ITestFixture_name(ITestFixture* pme)
{
	return pme->name;
}

static PFNTEST  __ITestFixture_test(ITestFixture* pme)
{
	return pme->test;
}


ITestFixture* ITestFixture_Ctor(ITestFixture* pme, char* name, PFNTEST test)
{
	pme->pvt = &g_ITestFixtureVtbl;
	act_strncpy(pme->name, name,ACT_TEST_NAME_LENGTH);
	pme->test = test;

	return pme;
}
#endif

// 
// ITestCaller Implementation
//


ITestCaller* ITestCaller_New(char * name, PFNSETUP setup, PFNTEARDWON tdw)
{
    ITestCaller* pme;

    pme = (ITestCaller*) act_malloc(sizeof(ITestCaller));

    return ITestCaller_Ctor(pme, name, setup, tdw);
}

static void __ITestCaller_Delete(ITestCaller* pme)
{
    if(pme)
    {
        ITestFixtureList_Delete(pme->m_lstFixture, TRUE);
        act_free(pme);
        pme = NULL;
    }
}

void ITestCaller_Delete(ITestCaller* pme)
{
    if(pme)
    {
        ITestFixtureList_Delete(pme->m_lstFixture, TRUE);
        act_free(pme);
        pme = NULL;
    }
}

ITestCaller* ITestCaller_Ctor(ITestCaller* pme, char * name, PFNSETUP setup, PFNTEARDWON tdw)
{
	pme->pvt = (ITestCallerVtbl*)&g_ITestCallerVtbl;
	act_strncpy(pme->name,name, ACT_TEST_NAME_LENGTH);
	pme->setUp = setup;
	pme->tearDown = tdw;

    pme->m_lstFixture = ITestFixtureList_New();
//	pme->numberOfFixtuers = 0;

	return pme;
}



static char* __ITestCaller_name(ITestCaller* pme)
{
	return pme->name;
}

static void __ITestCaller_run(ITestCaller* pme,ITestResult* result)
{
	ITestFixture* pITestFixture;
    ITestFixtureNode * pITestFixtureNode;
        int numberOfFixtures;
	int i;

	ITestCase cs;
	ITestCase_Ctor(&cs,"",NULL,NULL,NULL);

	cs.setUp= pme->setUp;
	cs.tearDown	= pme->tearDown;

        numberOfFixtures = ITestFixtureList_GetCount(pme->m_lstFixture);
        pITestFixtureNode = (ITestFixtureNode *)ITestFixtureList_GetHeadPosition(pme->m_lstFixture);
        
        for(i = 0; i < numberOfFixtures; i++)
        {
            pITestFixture = (ITestFixture *)ITestFixtureList_GetNext(pme->m_lstFixture, &pITestFixtureNode);
            act_strncpy(cs.name, ITestFixture_name(pITestFixture), ACT_TEST_NAME_LENGTH);
 	    cs.runTest	= ITestFixture_test(pITestFixture);
            ITest_run(&cs, result);
        }
#if 0
	for (i=0; i<pme->numberOfFixtuers; i++) {
		pITestFixture =  pme->fixtures[i];
		act_strncpy (cs.name, ITestFixture_name(pITestFixture), ACT_TEST_NAME_LENGTH);
		cs.runTest	= ITestFixture_test(pITestFixture);
		/*run test*/
		ITest_run(&cs,result);
	}
#endif
}

static int __ITestCaller_countTestCases(ITestCaller* pme)
{
//	return //pme->numberOfFixtuers;
    return ITestFixtureList_GetCount(pme->m_lstFixture);
}

static void __ITestCaller_AddTestFixture(ITestCaller* pme, ITestFixture* pFixture)
{
	//pme->fixtures[pme->numberOfFixtuers] = pFixture;
	//pme->numberOfFixtuers++;
	ITestFixtureList_AddTail(pme->m_lstFixture, pFixture);
}

