
#include "actconfig.h"
#include "actcomdef.h"
#include "actstdlib.h"
#include "acttestfixture.h"
#include "acttestfixture_private.h"

static ITestFixtureVtbl g_ITestFixtureVtbl = {
    __ITestFixture_Delete,
	__ITestFixture_name,
	__ITestFixture_test,
};

// 
// ITestFixture Implementation
//

ITestFixture* ITestFixture_New(char* name, PFNTEST test)
{
    ITestFixture* pMe;

    pMe = (ITestFixture*) act_malloc(sizeof(ITestFixture));

    return ITestFixture_Ctor(pMe, name, test);
}

static void     __ITestFixture_Delete(ITestFixture* pMe)
{
    if(pMe)
    {
       act_free(pMe);
    }
}


ITestFixture* ITestFixture_Ctor(ITestFixture* pme, char* name, PFNTEST test)
{
	pme->pvt = &g_ITestFixtureVtbl;
	act_strncpy(pme->name, name,ACT_TEST_NAME_LENGTH);
	pme->test = test;

	return pme;
}

static char* __ITestFixture_name(ITestFixture* pme)
{
	return pme->name;
}

static PFNTEST  __ITestFixture_test(ITestFixture* pme)
{
	return pme->test;
}


