
#include "actConfig.h"
#include "actComDef.h"
#include "actStdLib.h"
#include "actTest.h"
#include "actTestRepeat.h"
#include "actTestRepeat_private.h"

static const ITestVtbl g_ITestVtbl = 
{
    (PFNTestDelete)     __ITestRepeat_Delete,
	(PFNTestName)		__ITestRepeat_name,
	(PFNTestRun)		__ITestRepeat_run,
	(PFNCountTestCases)	__ITestRepeat_countTestCases,
};

ITestRepeat* ITestRepeat_New( ITest* test, int timesRepeat)
{
    ITestRepeat* pMe;

    pMe = (ITestRepeat*) act_malloc(sizeof(ITestRepeat));

    return ITestRepeat_Ctor(pMe, test, timesRepeat);
}

static void __ITestRepeat_Delete(ITestRepeat* pMe)
{	
    if(pMe)
    {
        act_free(pMe);	
    }
}

ITestRepeat* ITestRepeat_Ctor(ITestRepeat* pme, ITest* test, int timesRepeat)
{
	pme->pvt = (ITestVtbl*) &g_ITestVtbl;
	pme->test = test;
	pme->timesRepeat = timesRepeat;

	return pme;
}



static char* __ITestRepeat_name(ITestRepeat* pme)
{	
	return ITest_name(pme->test);
}

static void __ITestRepeat_run(ITestRepeat* pme,ITestResult* result)
{
	int i;
	ITest* test = pme->test;
	for (i=0; i<pme->timesRepeat; i++) {
		ITest_run(test, result);
	}
}

static int __ITestRepeat_countTestCases(ITestRepeat* pme)
{
	return ITest_countTestCases(pme->test) * pme->timesRepeat;
}
