
#include "actTest.h"
#include "actTestListener.h"
#include "actTestResult.h"

static void __ITestResult_init(ITestResult* pme,ITestListener* pListener);
static void __ITestResult_startTest(ITestResult* pme,ITest* test);
static void __ITestResult_endTest(ITestResult* pme,ITest* test);
static void __ITestResult_addFailure(ITestResult* pme,ITest* test,const char* msg,int line,const char* file);

static ITestResultVtbl g_ITestResultVtbl =
{
	__ITestResult_init,
	__ITestResult_startTest,
	__ITestResult_endTest,
	__ITestResult_addFailure
	
};

static void __ITestResult_init(ITestResult* pme,ITestListener* pListener)
{

	pme->runCount = 0;
	pme->failureCount = 0;
	pme->listener = pListener;
}

static void __ITestResult_startTest(ITestResult* pme,ITest* test)
{
	pme->runCount++;
	if (pme->listener) {
		ITestListener_startTest(pme->listener, test);
	}
}

static void __ITestResult_endTest(ITestResult* pme,ITest* test)
{
	if (pme->listener) {
		ITestListener_endTest(pme->listener, test);
	}
}

static void __ITestResult_addFailure(ITestResult* pme,ITest* test,const char* msg,int line,const char* file)
{
	pme->failureCount++;
	if (pme->listener) {
		ITestListener_addFailure(pme->listener, test, msg, line, file);
	}
}

ITestResult* ITestResult_Ctor(ITestResult* pme, ITestListener* pTestListener)
{
	pme->pvt = &g_ITestResultVtbl;
	pme->runCount = 0;
	pme->failureCount = 0;
	pme->listener = pTestListener;

	return pme;
}
