#include "act.h"
#include "actTests.h"
#include "actMockTestCase.h"

#ifdef ACT_TESTREPEAT_TESTS

static void setUp(void)
{
}

static void tearDown(void)
{
}

static void testRepeatedOnce(void)
{
    ITestRepeat test;
    ITestResult result;
    
    ITestRepeat_Ctor(&test, (ITest*)actMockTestCase_case(),1);
    ITestResult_Ctor(&result, NULL);
    
    ITest_run(&test, &result);
    
    ACT_TEST_ASSERT_EQUAL_INT(1, result.runCount);
    ACT_TEST_ASSERT_EQUAL_INT(1, ITest_countTestCases(&test));
}

static void testRepeatedMoreThanOnce(void)
{
    ITestRepeat test;
    ITestResult result;
    
    ITestRepeat_Ctor(&test, (ITest*)actMockTestCase_case(),100);
    ITestResult_Ctor(&result, NULL);
    
    ITest_run(&test, &result);
    
    ACT_TEST_ASSERT_EQUAL_INT(100, result.runCount);
    ACT_TEST_ASSERT_EQUAL_INT(100, ITest_countTestCases(&test));
}

static void testRepeatedZero(void)
{
    ITestRepeat test;
    ITestResult result;
    
    ITestRepeat_Ctor(&test, (ITest*)actMockTestCase_case(),0);
    ITestResult_Ctor(&result, NULL);
    
    ITest_run(&test, &result);
    
    ACT_TEST_ASSERT_EQUAL_INT(0, result.runCount);
    ACT_TEST_ASSERT_EQUAL_INT(0, ITest_countTestCases(&test));
}

ITest* TestRepeatTest_tests(void)
{
    ITestCaller* pTestRepeatTest;

    pTestRepeatTest = ITestCaller_New("RepeatedTestTest",setUp,tearDown);
//    ACT_TESTCALLER_NEW(RepeatedTestTest,"RepeatedTestTest",setUp,tearDown);
    
    ACT_ADD_FIXTURE(pTestRepeatTest,"testRepeatedOnce",testRepeatedOnce);
    ACT_ADD_FIXTURE(pTestRepeatTest,"testRepeatedMoreThanOnce",testRepeatedMoreThanOnce);
    ACT_ADD_FIXTURE(pTestRepeatTest,"testRepeatedZero",testRepeatedZero);
    
    return (ITest*)pTestRepeatTest;
}

#endif // def ACT_TESTREPEAT_TESTS
