#ifndef __ACTTEST_H__
#define __ACTTEST_H__


typedef struct __ITestResult ITestResult; 

typedef struct __ITest	ITest;

typedef struct __ITestVtbl	ITestVtbl;

typedef uint32  (*PFNTestAddRef)    (void*);
typedef void    (*PFNTestDelete)    (void*);
typedef char*   (*PFNTestName)      (void*);
typedef void    (*PFNTestRun)       (void*,ITestResult*);
typedef int     (*PFNTestCountTestCases)(void*);
typedef int     (*PFNTestGetChildTestCount)(void*);
typedef ITest *(*PFNTestGetChildTestAt)(void*, int );
typedef ITest*     (*PFNTestFindTest)(void*, char *);

struct __ITestVtbl 
{
    PFNTestAddRef AddRef;
    PFNTestDelete Delete;
    PFNTestName name;
    PFNTestRun run;
    PFNTestCountTestCases countTestCases;
    PFNTestGetChildTestCount getChildTestCount;
    PFNTestGetChildTestAt  getChildTestAt;
    PFNTestFindTest findTest;
};


struct __ITest {
    ITestVtbl* pvt;
};

#define ITest_AddRef(s)         (*(ITestVtbl**)s)->AddRef(s)
#define ITest_Delete(s)         (*(ITestVtbl**)s)->Delete(s)
#define ITest_name(s)           (*(ITestVtbl**)s)->name(s)
#define ITest_run(s,r)          (*(ITestVtbl**)s)->run(s,r)
#define ITest_countTestCases(s) (*(ITestVtbl**)s)->countTestCases(s)
#define ITest_getChildTestCount(s) (*(ITestVtbl**)s)->getChildTestCount(s)
#define ITest_getChildTestAt(s,i) (*(ITestVtbl**)s)->getChildTestAt(s,i)
#define ITest_findTest(s,n) (*(ITestVtbl**)s)->findTest(s,n)

#endif /* __ACTTEST_H__ */
