#ifndef __ACTTESTCASE_H__
#define __ACTTESTCASE_H__

#include "acttest.h"

typedef void (*PFNSETUP)(void);
typedef void (*PFNTEARDWON)(void);
typedef void (*PFNRUNTEST)(void);

typedef struct __ITestCase ITestCase;

struct __ITestCase
{
	ITestVtbl* pvt;
    uint32 m_cRef;
	char name[ACT_TEST_NAME_LENGTH];
	void(*setUp)(void);
	void(*tearDown)(void);
	void(*runTest)(void);
};

ITestCase* ITestCase_New(char *name, PFNSETUP setup, PFNTEARDWON teardown, PFNRUNTEST runTest);
ITestCase* ITestCase_Ctor(ITestCase* pme, char *name, PFNSETUP setup, PFNTEARDWON teardown, PFNRUNTEST runTest);

#endif /* __ACTTESTCASE_H__ */
