
#ifndef	__ACTTESTLISTENER_H__
#define	__ACTTESTLISTENER_H__

typedef void(*TestListnerStartTestCallBack)(void*,void*);
typedef void(*TestListnerEndTestCallBack)(void*,void*);
typedef void(*TestListnerAddFailureCallBack)(void*,void*,const char*,int,const char*);

typedef struct __ITestListenerVtbl	ITestListenerVtbl;

struct __ITestListenerVtbl {
	TestListnerStartTestCallBack startTest;
	TestListnerEndTestCallBack endTest;
	TestListnerAddFailureCallBack addFailure;
};

/*typedef struct __ITestListener	ITestListner;*/	/*->actTestResult.h*/

struct __ITestListener {
	ITestListenerVtbl* pvt;
};

#define ITestListener_startTest(po,test)				(*(ITestListenerVtbl**)po)->startTest(po,test)
#define ITestListener_endTest(po,test)					(*(ITestListenerVtbl**)po)->endTest(po,test)
#define ITestListener_addFailure(po,test,msg,line,file)	(*(ITestListenerVtbl**)po)->addFailure(po,test,msg,line,file)

#endif/*__ACTTESTLISTENER_H__*/

