
#ifndef	__ACTTESTRUNNER_H__
#define	__ACTTESTRUNNER_H__

#ifdef	__cplusplus
extern "C" {
#endif

typedef struct __ITestRunner	ITestRunner;
typedef struct __ITestRunnerVtbl ITestRunnerVtbl;

struct __ITestRunnerVtbl {
	void (*start)(ITestRunner* po);
	void (*addTest)(ITestRunner* po, ITest* test);
    void (*runTest)(ITestRunner* po);
	void (*end)(ITestRunner*po);
};


#define ITestRunner_start(po)			(*(ITestRunnerVtbl**)po)->start(po)
#define ITestRunner_addTest(po,test)	(*(ITestRunnerVtbl**)po)->addTest(po,test)
#define ITestRunner_runTest(po)                 (*(ITestRunnerVtbl**)po)->runTest(po)
#define ITestRunner_end(po)				(*(ITestRunnerVtbl**)po)->end(po)

ITestRunner*    ITestRunner_New();
void            ITestRunner_Delete(ITestRunner* pMe);

ITestRunner*    ITestRunner_Alloc();
void            ITestRunner_Free(ITestRunner* pMe);

ITestRunner*    ITestRunner_Ctor(ITestRunner* pme);
void            ITestRunner_Xtor(ITestRunner* pMe);

#ifdef	__cplusplus
}
#endif

#endif/*__ACTTESTRUNNER_H__*/

