#ifndef __ACTTESTVECTOR_H__
#define __ACTTESTVECTOR_H__

//
//
//
#ifdef	__cplusplus
extern "C" {
#endif
    
typedef struct __ITestVec ITestVec;

typedef struct __ITestVecVtbl ITestVecVtbl;

struct __ITestVecVtbl {
 void        (*AddRef)(ITestVec* pMe);
 void        (*Delete)(ITestVec* pMe);

 void        (*push_back)(ITestVec* pMe, ITest* pTest);
 void        (*insert_before)(ITestVec* pMe, int n, ITest* pTest);
 void        (*erase)(ITestVec* pMe, int n);
 int         (*size)(ITestVec* pMe);
 int         (*capacity)(ITestVec* pMe);
 ITest*      (*get)(ITestVec* pMe, int n);
 void        (*clear)(ITestVec* pMe);
 int         (*find)(ITestVec* pMe,ITest* pTest);
    
};

#define ITestVec_AddRef(pme) (*(ITestVecVtbl**)pme)->AddRef(pme)
#define ITestVec_Delete(pme)  (*(ITestVecVtbl**)pme)->Delete(pme)
#define ITestVec_push_back(pme, pTest)  (*(ITestVecVtbl**)pme)->push_back(pme, pTest)
#define ITestVec_insert_before(pme, n, pTest)  (*(ITestVecVtbl**)pme)->insert_before(pme,n, pTest)
#define ITestVec_erase(pme, n)  (*(ITestVecVtbl**)pme)->erase(pme, n)
#define ITestVec_size(pme)  (*(ITestVecVtbl**)pme)->size(pme)
#define ITestVec_capacity(pme)  (*(ITestVecVtbl**)pme)->capacity(pme)
#define ITestVec_get(pme, n)  (*(ITestVecVtbl**)pme)->get(pme, n)
#define ITestVec_clear(pme)  (*(ITestVecVtbl**)pme)->clear(pme)
#define ITestVec_find(pme,pTest)  (*(ITestVecVtbl**)pme)->find(pme, pTest)

ITestVec*   ITestVec_New(int initial_capacity);


//
//
//

typedef struct __ITestVecIterator ITestVecIterator;

typedef struct __ITestVecIteratorVtbl ITestVecIteratorVtbl;

struct __ITestVecIteratorVtbl {
uint32  (*AddRef)(ITestVecIterator* pme);
void    (*Delete)(ITestVecIterator* pme);
void    (*First)(ITestVecIterator* pme);
void    (*Next)(ITestVecIterator* pme);
boolean (*IsDone)(ITestVecIterator* pme);
ITest*  (*CurrentItem)(ITestVecIterator* pme);

};

#define ITestVecIterator_AddRef(pme) (*(ITestVecIteratorVtbl**)pme)->AddRef(pme)
#define ITestVecIterator_Delete(pme) (*(ITestVecIteratorVtbl**)pme)->Delete(pme)
#define ITestVecIterator_First(pme) (*(ITestVecIteratorVtbl**)pme)->First(pme)
#define ITestVecIterator_Next(pme) (*(ITestVecIteratorVtbl**)pme)->Next(pme)
#define ITestVecIterator_IsDone(pme) (*(ITestVecIteratorVtbl**)pme)->IsDone(pme)
#define ITestVecIterator_CurrentItem(pme) (*(ITestVecIteratorVtbl**)pme)->CurrentItem(pme)

ITestVecIterator* ITestVecIterator_New(ITestVec* pTestVec);

#ifdef __cplusplus
}
#endif

#endif /* __ACTTESTVECTOR_H__ */