
#include "actconfig.h"
#include "actcomdef.h"
#include "actstdlib.h"
#include "acttest.h"
#include "acttestvector.h"
#include "acttestvector_private.h"


static ITestVecVtbl g_ITestVecVtbl = 
{
    __ITestVec_AddRef
    , __ITestVec_Delete
    , __ITestVec_push_back
    , __ITestVec_insert_before
    , __ITestVec_erase
    , __ITestVec_size
    , __ITestVec_capacity
    , __ITestVec_get
    , __ITestVec_clear
    , __ITestVec_find
};


ITestVec *  
ITestVec_New(int initial_capacity)
{
    ITestVec * pMe = (ITestVec *) act_malloc(sizeof(ITestVec));
    
    if(pMe)
    {
        pMe->pvt = &g_ITestVecVtbl;
        pMe->m_cRef = 1;
        pMe->size = 0;
        pMe->capa = 0;
        pMe->body = (ITest**)malloc(sizeof(ITest*)*initial_capacity);
        if ( pMe->body ) 
        {
            pMe->capa = initial_capacity;
        }
    }
    return pMe;
}

static uint32
__ITestVec_AddRef(ITestVec* pMe) 
{    
    return ++pMe->m_cRef;
}

static void
__ITestVec_Delete(ITestVec* pMe) 
{    
    if(--pMe->m_cRef == 0)
    {
        __ITestVec_clear(pMe);
        act_free(pMe);
    }
}

static void
__ITestVec_clear(ITestVec* pMe) 
{
    int i;
    for ( i = 0; i < pMe->size; ++i ) 
    {
        ITest_Delete(pMe->body[i]);
    }
    pMe->size = 0;
}


static void
__ITestVec_grow(ITestVec* pMe) 
{
    if ( pMe->size >= pMe->capa ) 
    {
        int new_capa = pMe->capa + 8;
        ITest** new_body = (ITest**)malloc(sizeof(ITest*) * new_capa);
        if ( new_body ) 
        {
            int i;
            for ( i = 0; i < pMe->size; ++i ) 
            {
                new_body[i] = pMe->body[i];
            }
            act_free(pMe->body);
            pMe->body = new_body;
            pMe->capa = new_capa;
        }
    }
}

static void
__ITestVec_push_back(ITestVec* pMe, ITest* str)
{
    __ITestVec_grow(pMe);
    pMe->body[pMe->size++] = str; //strdup(str);
}

static void
__ITestVec_insert_before(ITestVec* pMe, int pos, ITest* str) {
    int i;
    if ( pos < 0 ) return;
    if ( pos >= pMe->size ) return;
    __ITestVec_grow(pMe);
    for ( i = pMe->size; i > pos; --i ) 
    {
        pMe->body[i] = pMe->body[i-1];
    }
    pMe->body[pos] = str; // strdup(str);
    ++pMe->size;
}

static int
__ITestVec_size(ITestVec* pMe) 
{
    return pMe->size;
}

static void
__ITestVec_erase(ITestVec* pMe, int pos) 
{
    int i;
    
    if ( pos < 0 ) return;
    if ( pos >= pMe->size ) return;
    
    ITest_Delete(pMe->body[pos]);

    for ( i = pos; i < pMe->size - 1; ++i ) 
    {
        pMe->body[i] = pMe->body[i+1];
    }
    --pMe->size;
}

static int
__ITestVec_capacity(ITestVec* pMe) 
{
    return pMe->capa;
}

static ITest* 
__ITestVec_get(ITestVec* pMe, int index) 
{
    if ( index >= 0 || index < pMe->size ) 
    {
        return pMe->body[index];
    }
    return 0;
}

static int
__ITestVec_find(ITestVec* pMe,  ITest* pTest) 
{
    int i;
    for ( i = 0; i < pMe->size; ++i ) 
    {
        if ( strcmp((const char*)ITest_name(pTest), (const char*)ITest_name(pMe->body[i])) == 0 ) 
            return i;
    }
    return -1;
}



static ITestVecIteratorVtbl g_ITestVecIteratorVtbl =
{
    __ITestVecIterator_AddRef
    ,__ITestVecIterator_Delete
    ,__ITestVecIterator_First
    ,__ITestVecIterator_Next
    ,__ITestVecIterator_IsDone
    ,__ITestVecIterator_CurrentItem
};

ITestVecIterator* ITestVecIterator_New(ITestVec* pTestVec)
{
    ITestVecIterator* pme;
    pme = (ITestVecIterator*) act_malloc(sizeof(ITestVecIterator));
    
    pme->pvt = &g_ITestVecIteratorVtbl;
    pme->m_cRef = 1;
    pme->m_pTestVec_ = pTestVec;
    pme->m_nCurrent_ = 0;   
    
    return pme;
}

static uint32    __ITestVecIterator_AddRef(ITestVecIterator* pme)
{
    return ++pme->m_cRef;   
}

static void    __ITestVecIterator_Delete(ITestVecIterator* pme)
{
    if(--pme->m_cRef == 0)
    {
        act_free(pme);
    }
}

static void    __ITestVecIterator_First(ITestVecIterator* pme)
{
    pme->m_nCurrent_ = 0;
}

static void    __ITestVecIterator_Next(ITestVecIterator* pme)
{
    pme->m_nCurrent_++;
}

static boolean __ITestVecIterator_IsDone(ITestVecIterator* pme)
{
    return pme->m_nCurrent_ >= ITestVec_size(pme->m_pTestVec_);
}


static ITest* __ITestVecIterator_CurrentItem(ITestVecIterator* pme)
{
    return ITestVec_get(pme->m_pTestVec_, pme->m_nCurrent_);
}