/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#include "act.h"
#include "counter.h"

Counter* counterRef;

static void setUp(void)
{
	counterRef = Counter_New();
}

static void tearDown(void)
{
	Counter_Delete(counterRef);
}

static void testInit(void)
{
	ACT_TEST_ASSERT_EQUAL_INT(0, Counter_GetValue(counterRef));
}

static void testSetValue(void)
{
	Counter_SetValue(counterRef,1);
	ACT_TEST_ASSERT_EQUAL_INT(1, Counter_GetValue(counterRef));

	Counter_SetValue(counterRef,-1);
	ACT_TEST_ASSERT_EQUAL_INT(-1, Counter_GetValue(counterRef));
}

static void testInc(void)
{
	Counter_Inc(counterRef);	
	ACT_TEST_ASSERT_EQUAL_INT(1, Counter_GetValue(counterRef));

	Counter_Inc(counterRef);	
	ACT_TEST_ASSERT_EQUAL_INT(2, Counter_GetValue(counterRef));
}

static void testDec(void)
{
	Counter_Dec(counterRef);
	ACT_TEST_ASSERT_EQUAL_INT(-1, Counter_GetValue(counterRef));

	Counter_Dec(counterRef);
	ACT_TEST_ASSERT_EQUAL_INT(-2, Counter_GetValue(counterRef));
}

static void testClr(void)
{
	Counter_Inc(counterRef);
	ACT_TEST_ASSERT_EQUAL_INT(1, Counter_GetValue(counterRef));

	Counter_Clr(counterRef);
	ACT_TEST_ASSERT_EQUAL_INT(0, Counter_GetValue(counterRef));
}

ITest* CounterTest_tests(void)
{
    ITestCaller* pCounterTest;
	ACT_TESTCALLER_NEW(pCounterTest, "CounterTest",setUp,tearDown);
		ACT_ADD_FIXTURE(pCounterTest, "testInit",testInit);
		ACT_ADD_FIXTURE(pCounterTest, "testSetValue", testSetValue);
		ACT_ADD_FIXTURE(pCounterTest, "testInc", testInc);
		ACT_ADD_FIXTURE(pCounterTest, "testDec", testDec);
		ACT_ADD_FIXTURE(pCounterTest, "testClr", testClr);

	return (ITest*)pCounterTest;
}

