/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef	__PERSON_H__
#define	__PERSON_H__

typedef struct __Person		Person;

struct __Person {
	char *fullname;
	char *firstname;
	char *lastname;
};

Person* Person_Alloc(void);
void    Person_Free(Person*);
Person* Person_Ctor(Person*);
Person* Person_CtorWithName(Person*,char*);

Person* Person_NewWithName(char*);
void      Person_Delete(Person*);

char* Person_GetFullName(Person*);
char* Person_GetFirstName(Person*);
char* Person_GetLastName(Person*);

void Person_SetFullName(Person*,char*);
void Person_SetFirstName(Person*,char*);
void Person_SetLastName(Person*,char*);

#endif/*__PERSON_H__*/

