/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#include <malloc.h>
#include "SimpleCalc.h"


SimpleCalc* SimpleCalc_Alloc()
{
    return (SimpleCalc*)malloc(sizeof(SimpleCalc));
}


void        SimpleCalc_Free(SimpleCalc* pMe)
{
	free(pMe);
}

SimpleCalc* SimpleCalc_Ctor(SimpleCalc* pMe)
{
    SimpleCalc_SetValue(pMe, 0, 0);
	return pMe;
}

SimpleCalc* SimpleCalc_CtorEx(SimpleCalc* pMe, int x, int y)
{
    SimpleCalc_SetValue(pMe, x, y);
	return pMe;
}


SimpleCalc* SimpleCalc_New(void)
{
    return SimpleCalc_Ctor(SimpleCalc_Alloc());
}


SimpleCalc* SimpleCalc_NewEx(int x, int y)
{
    return SimpleCalc_CtorEx(SimpleCalc_Alloc(), x, y);
}


void        SimpleCalc_Delete(SimpleCalc* pMe)
{
    SimpleCalc_Free(pMe);
}


void        SimpleCalc_SetValue(SimpleCalc* pMe, int x, int y)
{
    if(pMe)
    {
        pMe->m_nX = x;
        pMe->m_nY = y;
    }
}


void        SimpleCalc_GetValue(SimpleCalc* pMe, int *x, int *y)
{
    if(x)
    {
        *x = pMe->m_nX;
    }

    if(y)
    {
        *y = pMe->m_nY;
    }
}


int         SimpleCalc_Sum(SimpleCalc* pMe)
{
    int nAnswer;

    nAnswer = pMe->m_nX + pMe->m_nY;
    return nAnswer;
}


int         SimpleCalc_Sub(SimpleCalc* pMe)
{
    int nAnswer;

    nAnswer = pMe->m_nX - pMe->m_nY;
    return nAnswer;
}
