/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#include "act.h"
#include "actTestRunnerMfc.h"
#include "SimpleCalc.h"


SimpleCalc* pSimpleCalc;


static void setUp(void)
{
	pSimpleCalc = SimpleCalc_NewEx(2,1);
}

static void tearDown(void)
{
	SimpleCalc_Delete(pSimpleCalc);
}


static void testNewEx(void)
{
    int x,y;

    SimpleCalc_GetValue(pSimpleCalc, &x, &y);

	ACT_TEST_ASSERT_EQUAL_INT(2, x);
    ACT_TEST_ASSERT_EQUAL_INT(1, y);
}

static void testSum(void)
{
    int nSum;

    nSum = SimpleCalc_Sum(pSimpleCalc);
	ACT_TEST_ASSERT_EQUAL_INT(3, nSum);
	ACT_TEST_ASSERT_EQUAL_INT(1, nSum);
}


ITest* SimpleCalcTest_tests()
{
    ITestCaller *pCaller;
    ACT_TESTCALLER_NEW(pCaller, "SimpleCalcTest_tests",setUp, tearDown);

    ACT_ADD_FIXTURE(pCaller, "testNewEx", testNewEx);
    ACT_ADD_FIXTURE(pCaller, "testSum", testSum);
    
    return (ITest*) pCaller;
}

void TestRunner_Executor()
{
    ITest* pTest;
    ITestRunnerMfc* pTestRunner;

    _ITestRunnerMfc_new(&pTestRunner);

    ITestRunnerMfc_start(pTestRunner);

    pTest = SimpleCalcTest_tests();
        ITestRunnerMfc_addTest(pTestRunner, pTest);
        ITestRunnerMfc_runTest(pTestRunner);
        
    
    ITestRunnerMfc_end(pTestRunner);

    ITestRunnerMfc_release(pTestRunner);
}
