/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef __ACTCLASSIDS_H__
#define  __ACTCLASSIDS_H__

/**
@file actclassids.h

@brief ACT class IDs

base level definitions for ACT classes
*/

// base ID 
#define ACTIDBASE 						0x01007800

#define ACTIID_UNKNOWN    				(ACTIDBASE + 0x000)
#define ACTCLSID_UNKNOWN				(ACTIDBASE + 0x001)

#define ACTIID_TEST                     (ACTIDBASE + 0x002)
#define ACTCLSID_TEST                   (ACTIDBASE + 0x003)

#define ACTIID_TESTCASE                 (ACTIDBASE + 0x004)
#define ACTCLSID_TESTCASE               (ACTIDBASE + 0x005)

#define ACTIID_TESTSUITE                (ACTIDBASE + 0x006)
#define ACTCLSID_TESTSUITE              (ACTIDBASE + 0x007)

#define ACTIID_TESTLIST                 (ACTIDBASE + 0x008)
#define ACTCLSID_TESTLIST               (ACTIDBASE + 0x009)

#define ACTIID_TESTRESULT               (ACTIDBASE + 0x00a)
#define ACTCLSID_TESTRESULT             (ACTIDBASE + 0x00b)

#define ACTIID_TESTLISTENER             (ACTIDBASE + 0x00c)
#define ACTCLSID_TESTLISTENER           (ACTIDBASE + 0x00d)

#define ACTIID_TESTRUNNER               (ACTIDBASE + 0x00e)
#define ACTCLSID_TESTRUNNER             (ACTIDBASE + 0x00f)

#define ACTIID_TESTREPEAT               (ACTIDBASE + 0x010)
#define ACTCLSID_TESTREPEAT             (ACTIDBASE + 0x011)

#define ACTIID_TESTFIXTURE              (ACTIDBASE + 0x012)
#define ACTCLSID_TESTFIXTURE            (ACTIDBASE + 0x013)

#define ACTIID_TESTCALLER               (ACTIDBASE + 0x014)
#define ACTCLSID_TESTCALLER             (ACTIDBASE + 0x015)

#define ACTIID_TESTFIXTURELIST          (ACTIDBASE + 0x016)
#define ACTCLSID_TESTFIXTURELIST        (ACTIDBASE + 0x017)

#define ACTIID_TESTVECTOR               (ACTIDBASE + 0x018)
#define ACTCLSID_TESTVECTOR             (ACTIDBASE + 0x019)

#define ACTIID_TESTVECTORITERATOR       (ACTIDBASE + 0x01a)
#define ACTCLSID_TESTVECTORITERATOR     (ACTIDBASE + 0x01b)

#define ACTIID_TESTLISTENERMFC          (ACTIDBASE + 0x01c)
#define ACTCLSID_TESTLISTENERMFC        (ACTIDBASE + 0x01d)

#define ACTIID_TESTRUNNERMFC            (ACTIDBASE + 0x01e)
#define ACTCLSID_TESTRUNNERMFC          (ACTIDBASE + 0x01f)

#define ACTID_RNAGE 					(       0x000007ff)



#endif /*  __ACTCLASSIDS_H__ */
