/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef __ACTTESTFIXTURELIST_H__
#define __ACTTESTFIXTURELIST_H__

// Double Linked List for ITestFixture

#include "acttestfixture.h"

#ifdef WIN32
#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#endif // WIN32

#ifdef	__cplusplus
extern "C" {
#endif

typedef struct __ITestFixtureNode ITestFixtureNode;

typedef struct __ITestFixtureList ITestFixtureList;

typedef struct __ITestFixtureListVtbl ITestFixtureListVtbl;

struct __ITestFixtureListVtbl
{
/// IUnknown interface    

    uint32 (* addRef) (ITestFixtureList* pobj);

    uint32 (* release) (ITestFixtureList* pobj);

    ACTRESULT (*queryInterface)(ITestFixtureList* pobj, ACTCLSID clsid, void ** ppNew);
    
/// Head/Tail Access

	/// Returns the head element of the list (cannot be empty).
	const ITestFixture* (* getHead)(ITestFixtureList *pMe);
	/// Returns the tail element of the list (cannot be empty).
	const ITestFixture* (* getTail)(ITestFixtureList *pMe);

/// Operations

	/// removes the element from the head of the list.
	ITestFixture* (* removeHead)(ITestFixtureList *pMe, boolean bDataDelete);

	/// removes the element from the tail of the list. 
	ITestFixture* (* removeTail)(ITestFixtureList *pMe, boolean bDataDelete);
	
	/// adds an element (or all the elements in another list) to the head of the list (makes a new head).
	ITestFixtureNode* (* addHead)(ITestFixtureList *pMe, ITestFixture* pItem);

	/// adds an element (or all the elements in another list) to the tail of the list (makes a new tail).
	ITestFixtureNode* (* addTail)(ITestFixtureList *pMe, ITestFixture* pItem);
	
	/// removes all the elements from this list.
	// bDataDelete = FALSE ̸ Ʈ ͵ ݵ ڰ delete Ѵ.
	void (* removeAll)(ITestFixtureList *pMe, boolean bDataDelete);	

/// Iteration

	/// Returns the position of the head element of the list.
	const ITestFixtureNode* (* getHeadPosition)(ITestFixtureList *pMe);

	/// Returns the position of the tail element of the list.
	const ITestFixtureNode* (* getTailPosition)(ITestFixtureList *pMe);
	
	/// gets the next element for iterating.
	const ITestFixture* (* getNext)(ITestFixtureList *pMe, ITestFixtureNode** lppPosition);
	
	/// gets the previous element for iterating.
	const ITestFixture* (* getPrev)(ITestFixtureList *pMe, ITestFixtureNode** lppPosition);

/// Retrieval/Modification

	/// gets the element at a given position.
	const ITestFixture* (* getAt)(ITestFixtureList *pMe, ITestFixtureNode* position);

	/// sets the element at a given position.
	void (* SetAt)(ITestFixtureList *pMe, ITestFixtureNode* pos, ITestFixture* newElement, boolean bDeleteData);
	
	/// removes an element from this list, specified by position.
	void (* removeAt)(ITestFixtureList *pMe, ITestFixtureNode* position, boolean bDeleteData);
	
/// insertion

	/// inserts a new element before a given position.
	ITestFixtureNode* (* insertBefore)(ITestFixtureList *pMe, ITestFixtureNode* pos, ITestFixture* newElement);

	/// inserts a new element after a given position.
	ITestFixtureNode* (* insertAfter)(ITestFixtureList *pMe, ITestFixtureNode* pos, ITestFixture* newElement);
	
/// Searching

	/// gets the position of an element specified by pointer value.
	const ITestFixtureNode* (* find)(ITestFixtureList *pMe, ITestFixture* searchValue, ITestFixtureNode* startAfter);

	/// gets the position of an element specified by a zero-based index.
	const ITestFixtureNode* (* findIndex)(ITestFixtureList *pMe, int nIndex);

	/// gets the number of an element specified by pointer value.
	const int (* getNo)(ITestFixtureList *pMe, ITestFixture* searchValue, ITestFixtureNode* startAfter);
	
/// Status

	/// Returns the number of elements in this list.
	int (* getCount)(ITestFixtureList *pMe);
	
	/// Tests for the empty list condition (no elements).
	boolean (* isEmpty)(ITestFixtureList *pMe);
};



/// IUnknown interface

        /// add reference
#define ITestFixtureList_addRef(po) (*((ITestFixtureListVtbl**)po))->addRef(po)

        /// release interface
#define ITestFixtureList_release(po) (*((ITestFixtureListVtbl**)po))->release(po)

        /// query interface
#define ITestFixtureList_queryInterface(po,id,ppn) (*((ITestFixtureListVtbl**)po))->queryInterface(po,id,ppn)

/// Operations

	/// removes the element from the head of the list.
#define ITestFixtureList_removeHead(pMe, bDataDelete) (*(ITestFixtureListVtbl**)pMe)->removeHead(pMe, bDataDelete)

	/// removes the element from the tail of the list. 
#define ITestFixtureList_removeTail(pMe, bDataDelete) (*(ITestFixtureListVtbl**)pMe)->removeTail(pMe, bDataDelete)
	
	/// adds an element (or all the elements in another list) to the head of the list (makes a new head).
#define ITestFixtureList_addHead(pMe, pItem) (*(ITestFixtureListVtbl**)pMe)->addHead(pMe, pItem)

	/// adds an element (or all the elements in another list) to the tail of the list (makes a new tail).
#define ITestFixtureList_addTail(pMe, pItem) (*(ITestFixtureListVtbl**)pMe)->addTail(pMe, pItem)
	
	/// removes all the elements from this list.
	// bDataDelete = FALSE ̸ Ʈ ͵ ݵ ڰ delete Ѵ.
#define ITestFixtureList_removeAll(pMe, bDataDelete) (*(ITestFixtureListVtbl**)pMe)->removeAll(pMe, bDataDelete)

/// Iteration

	/// Returns the position of the head element of the list.
#define ITestFixtureList_getHeadPosition(pMe) (*(ITestFixtureListVtbl**)pMe)->getHeadPosition(pMe)

	/// Returns the position of the tail element of the list.
#define ITestFixtureList_getTailPosition(pMe) (*(ITestFixtureListVtbl**)pMe)->getTailPosition(pMe)
	
	/// gets the next element for iterating.
#define ITestFixtureList_getNext(pMe, lppPosition) (*(ITestFixtureListVtbl**)pMe)->getNext(pMe, lppPosition)
	
	/// gets the previous element for iterating.
#define ITestFixtureList_getPrev(pMe, lppPosition) (*(ITestFixtureListVtbl**)pMe)->getPrev(pMe, lppPosition)

/// Retrieval/Modification

	/// gets the element at a given position.
#define ITestFixtureList_getAt(pMe, position) (*(ITestFixtureListVtbl**)pMe)->getAt(pMe, position)

	/// sets the element at a given position.
#define ITestFixtureList_setAt(pMe, pos, newElement, bDeleteData) (*(ITestFixtureListVtbl**)pMe)->setAt(pMe, pos, newElement, bDeleteData)
	
	/// removes an element from this list, specified by position.
#define ITestFixtureList_removeAt(pMe, position, bDeleteData)(*(ITestFixtureListVtbl**)pMe)->removeAt(pMe, position, bDeleteData)(*(ITestFixtureListVtbl**)pMe)
	
/// insertion

	/// inserts a new element before a given position.
#define ITestFixtureList_insertBefore(pMe, pos, newElement) (*(ITestFixtureListVtbl**)pMe)->insertBefore(pMe, pos, newElement) 

	/// inserts a new element after a given position.
#define ITestFixtureList_insertAfter(pMe, pos, newElement) (*(ITestFixtureListVtbl**)pMe)->insertAfter(pMe, pos, newElement)
	
/// Searching

	/// gets the position of an element specified by pointer value.
#define ITestFixtureList_find(pMe, searchValue, startAfter) (*(ITestFixtureListVtbl**)pMe)->find(pMe, searchValue, startAfter) 

	/// gets the position of an element specified by a zero-based index.
#define ITestFixtureList_findIndex(pMe, nIndex) (*(ITestFixtureListVtbl**)pMe)->findIndex(pMe, nIndex) 

	/// gets the number of an element specified by pointer value.
#define ITestFixtureList_getNo(pMe, searchValue, startAfter) (*(ITestFixtureListVtbl**)pMe)->getNo(pMe, searchValue, startAfter)
	
/// Status

	/// Returns the number of elements in this list.
#define ITestFixtureList_getCount(pMe) (*(ITestFixtureListVtbl**)pMe)->getCount(pMe)
	
	/// Tests for the empty list condition (no elements).
#define ITestFixtureList_isEmpty(pMe) (*(ITestFixtureListVtbl**)pMe)->isEmpty(pMe) 

#ifdef	__cplusplus
}
#endif

#endif /*  __ACTTESTFIXTURELIST_H__ */

