/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef	__ACTTESTREPEAT_H__
#define	__ACTTESTREPEAT_H__

#include "acttestresult.h"

typedef struct __ITestRepeat	ITestRepeat;

typedef struct __ITestRepeatVtbl ITestRepeatVtbl;

struct __ITestRepeatVtbl
{
    uint32 (* addRef) (ITestRepeat* pobj);
    uint32 (* release) (ITestRepeat* pobj);
    ACTRESULT (*queryInterface)(ITestRepeat* pobj, ACTCLSID clsid, void ** ppNew);    
    char* (*name)(ITestRepeat* pobj);
    void (*run)(ITestRepeat* pobj, ITestResult* pResult);
    int  (*countTestCases)(ITestRepeat* pobj);
    int  (*getChildTestCount)(ITestRepeat* pobj);
    ITest* (*getChildTestAt)(ITestRepeat* pobj, int index);
    ITest* (*findTest)(ITestRepeat* pobj, char *name);    

    ACTRESULT(*init)(ITestRepeat* pobj, ITest* test, int timesRepeat);
};

#define ITestRepeat_addRef(pobj)         (*(ITestRepeatVtbl**)pobj)->addRef(pobj)
#define ITestRepeat_release(pobj)         (*(ITestRepeatVtbl**)pobj)->release(pobj)
#define ITestRepeat_queryInterface(po,id,ppn) (*((ITestRepeatVtbl**)po))->queryInterface(po,id,ppn)

#define ITestRepeat_name(pobj)           (*(ITestRepeatVtbl**)pobj)->name(pobj)
#define ITestRepeat_run(pobj,r)          (*(ITestRepeatVtbl**)pobj)->run(pobj,r)
#define ITestRepeat_countTestExCases(pobj) (*(ITestRepeatVtbl**)pobj)->countTestCases(pobj)
#define ITestRepeat_getChildTestCount(pobj) (*(ITestRepeatVtbl**)pobj)->getChildTestCount(pobj)
#define ITestRepeat_getChildTestAt(pobj,i) (*(ITestRepeatVtbl**)pobj)->getChildTestAt(pobj,i)
#define ITestRepeat_findTest(pobj,n) (*(ITestRepeatVtbl**)pobj)->findTest(pobj,n)

#define ITestRepeat_init(pobj, test, times) (*(ITestRepeatVtbl**)pobj)->init(pobj,test, times)

#endif /* __ACTTESTREPEAT_H__ */

