/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef __ACTTESTVECTOR_H__
#define __ACTTESTVECTOR_H__

#include "acttest.h"
#ifdef	__cplusplus
extern "C" {
#endif


typedef struct __ITestVec ITestVec;

typedef struct __ITestVecVtbl ITestVecVtbl;

struct __ITestVecVtbl {
 uint32        (*addRef)(ITestVec* pMe);
 uint32        (*release)(ITestVec* pMe);
 ACTRESULT (*queryInterface)(ITestVec* pobj, ACTCLSID clsid, void ** ppNew);
 ACTRESULT       (*init)(ITestVec* pobj, int initial_capacity);
 void        (*push_back)(ITestVec* pMe, ITest* pTest);
 void        (*insert_before)(ITestVec* pMe, int n, ITest* pTest);
 void        (*erase)(ITestVec* pMe, int n);
 int         (*size)(ITestVec* pMe);
 int         (*capacity)(ITestVec* pMe);
 ITest*      (*get)(ITestVec* pMe, int n);
 void        (*clear)(ITestVec* pMe);
 int         (*find)(ITestVec* pMe,ITest* pTest);
    
};

#define ITestVec_addRef(pme) (*(ITestVecVtbl**)pme)->addRef(pme)
#define ITestVec_release(pme)  (*(ITestVecVtbl**)pme)->release(pme)
#define ITestVec_queryInterface(pobj, clsid, ppn)  (*(ITestVecVtbl**)pobj)->queryInterface(pobj, clsid, ppn)
#define ITestVec_init(pme,initial_capacity)  (*(ITestVecVtbl**)pme)->init(pme, initial_capacity)
#define ITestVec_push_back(pme, pTest)  (*(ITestVecVtbl**)pme)->push_back(pme, pTest)
#define ITestVec_insert_before(pme, n, pTest)  (*(ITestVecVtbl**)pme)->insert_before(pme,n, pTest)
#define ITestVec_erase(pme, n)  (*(ITestVecVtbl**)pme)->erase(pme, n)
#define ITestVec_size(pme)  (*(ITestVecVtbl**)pme)->size(pme)
#define ITestVec_capacity(pme)  (*(ITestVecVtbl**)pme)->capacity(pme)
#define ITestVec_get(pme, n)  (*(ITestVecVtbl**)pme)->get(pme, n)
#define ITestVec_clear(pme)  (*(ITestVecVtbl**)pme)->clear(pme)
#define ITestVec_find(pme,pTest)  (*(ITestVecVtbl**)pme)->find(pme, pTest)


//
//
//

typedef struct __ITestVecIterator ITestVecIterator;

typedef struct __ITestVecIteratorVtbl ITestVecIteratorVtbl;

struct __ITestVecIteratorVtbl {
uint32  (*addRef)(ITestVecIterator* pme);
uint32    (*release)(ITestVecIterator* pme);
 ACTRESULT (*queryInterface)(ITestVecIterator* pobj, ACTCLSID clsid, void ** ppNew);
 ACTRESULT  (*init)(ITestVecIterator* pobj, ITestVec* pTestVec);
void    (*First)(ITestVecIterator* pme);
void    (*Next)(ITestVecIterator* pme);
boolean (*IsDone)(ITestVecIterator* pme);
ITest*  (*CurrentItem)(ITestVecIterator* pme);

};

#define ITestVecIterator_addRef(pme) (*(ITestVecIteratorVtbl**)pme)->addRef(pme)
#define ITestVecIterator_release(pme) (*(ITestVecIteratorVtbl**)pme)->release(pme)
#define ITestVecIterator_queryInterface(pobj, clsid, ppn)  (*(ITestVecIteratorVtbl**)pobj)->queryInterface(pobj, clsid, ppn)
#define ITestVecIterator_init(pme,pTestVec)  (*(ITestVecIteratorVtbl**)pme)->init(pme, pTestVec)
#define ITestVecIterator_First(pme) (*(ITestVecIteratorVtbl**)pme)->First(pme)
#define ITestVecIterator_Next(pme) (*(ITestVecIteratorVtbl**)pme)->Next(pme)
#define ITestVecIterator_IsDone(pme) (*(ITestVecIteratorVtbl**)pme)->IsDone(pme)
#define ITestVecIterator_CurrentItem(pme) (*(ITestVecIteratorVtbl**)pme)->CurrentItem(pme)

#ifdef __cplusplus
}
#endif

#endif /* __ACTTESTVECTOR_H__ */
