/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef __ACTTESTFIXTURE_PROTECTED_H__
#define  __ACTTESTFIXTURE_PROTECTED_H__

#include "acttestfixture.h"

struct __ITestFixture {
	ITestFixtureVtbl* pvt;
    uint32 m_cRef;
	char name[ACT_TEST_NAME_LENGTH];
	void(*test)(void);
};


ACTRESULT 
_ITestFixture_new(ITestFixture** ppobj);


void            
_ITestFixture_ctor(ITestFixture* pobj, ITestFixtureVtbl* pvt);


void 
_ITestFixture_initVtbl(ITestFixtureVtbl* pvt);


ACTRESULT 
_ITestFixture_init(ITestFixture* pobj, char* name, PFNTEST test);


uint32         
_ITestFixture_addRef(ITestFixture* pobj);


uint32          
_ITestFixture_release(ITestFixture* pobj);


void            
_ITestFixture_xtor(ITestFixture* pobj);


ACTRESULT   
_ITestFixture_queryInterface(ITestFixture* pobj, ACTCLSID clsid, void ** ppNew);


char*    
_ITestFixture_name(ITestFixture* pme);


PFNTEST  
_ITestFixture_test(ITestFixture* pme);

#endif /* __ACTTESTFIXTURE_PROTECTED_H__ */
