/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef __ACTTESTLISTENER_PROTECTED_H__
#define  __ACTTESTLISTENER_PROTECTED_H__

#include "acttest.h"
#include "acttestlistener.h"

struct __ITestListener {
	ITestListenerVtbl* pvt;
    uint32    m_cRef;
};

ACTRESULT _ITestListener_new(ITestListener** ppobj);

void 
_ITestListener_ctor(ITestListener* pme, ITestListenerVtbl* pvt);


void 
_ITestListener_initVtbl(ITestListenerVtbl* pvt);


ACTRESULT 
_ITestListener_init(ITestListener* pobj);


uint32 
_ITestListener_addRef(ITestListener* pobj);


uint32 
_ITestListener_release(ITestListener* pobj);


void 
_ITestListener_xtor(ITestListener* pme);

ACTRESULT 
_ITestListener_queryInterface(ITestListener* pobj, ACTCLSID clsid, void ** ppNew);

void _ITestListener_startTest(ITestListener* self,ITest* test);

void _ITestListener_endTest(ITestListener* self,ITest* test);

void _ITestListener_addFailure(ITestListener* self,ITest* test,const char* msg,int line,const char* file);
    
// defined in acttestrunner.c
ITest* _act_getRootTest();

#endif /* __ACTTESTLISTENER_PROTECTED_H__ */

