/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef __ACTTESTREPEAT_PROTECTED_H__ 
#define __ACTTESTREPEAT_PROTECTED_H__

#include "acttestrepeat.h"

struct __ITestRepeat {
	ITestRepeatVtbl* pvt;
	ITest* test;
    uint32 m_cRef;
	int timesRepeat;
};


ACTRESULT 
_ITestRepeat_new(ITestRepeat** ppobj);

void            
_ITestRepeat_ctor(ITestRepeat* pobj, ITestRepeatVtbl* pvt);

void 
_ITestRepeat_initVtbl(ITestRepeatVtbl* pvt);

ACTRESULT 
_ITestRepeat_init(ITestRepeat* pobj, ITest* test, int timesRepeat);

uint32         
_ITestRepeat_addRef(ITestRepeat* pobj);

uint32          
_ITestRepeat_release(ITestRepeat* pobj);

void            
_ITestRepeat_xtor(ITestRepeat* pobj);

ACTRESULT   
_ITestRepeat_queryInterface(ITestRepeat* pobj, ACTCLSID clsid, void ** ppNew);

char* 
_ITestRepeat_name(ITestRepeat* pobj);

void 
_ITestRepeat_run(ITestRepeat* pme,ITestResult* pResult);


int 
_ITestRepeat_countTestCases(ITestRepeat* pme);


int 
_ITestRepeat_getChildTestCount(ITestRepeat* pme);


ITest* 
_ITestRepeat_getChildTestAt(ITestRepeat* pme, int index);


ITest* 
_ITestRepeat_findTest(ITestRepeat* pme,char * pszName);


char* 
_ITestRepeat_name(ITestRepeat* pobj);


void 
_ITestRepeat_run(ITestRepeat* pme,ITestResult* pResult);


int 
_ITestRepeat_countTestCases(ITestRepeat* pme);


int 
_ITestRepeat_getChildTestCount(ITestRepeat* pme);


ITest* 
_ITestRepeat_getChildTestAt(ITestRepeat* pme, int index);


ITest* 
_ITestRepeat_findTest(ITestRepeat* pme,char * pszName);

#endif /* __ACTTESTREPEAT_PROTECTED_H__ */
