/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef __ACTTESTRESULT_PROTECTED_H__
#define __ACTTESTRESULT_PROTECTED_H__
/**
@file acttestresult_protected.h
*/
#include "acttestresult.h"

struct __ITestResult {
	ITestResultVtbl* pvt;
    uint32    m_cRef;
	int runCount;
	int failureCount;
	ITestListener* listener;
};

ACTRESULT 
_ITestResult_new(ITestResult** ppobj);

void 
_ITestResult_ctor(ITestResult* pme, ITestResultVtbl* pvt);



void 
_ITestResult_initVtbl(ITestResultVtbl* pvt);

ACTRESULT 
_ITestResult_init(ITestResult* pobj, ITestListener* piTestListener);

uint32 
_ITestResult_addRef(ITestResult* pobj);


uint32 
_ITestResult_release(ITestResult* pobj);


void 
_ITestResult_xtor(ITestResult* pme);


ACTRESULT 
_ITestResult_queryInterface(ITestResult* pobj, ACTCLSID clsid, void ** ppNew);



void 
_ITestResult_startTest(ITestResult* pme,ITest* test);

void 
_ITestResult_endTest(ITestResult* pme,ITest* test);

void 
_ITestResult_addFailure(ITestResult* pme,ITest* test,const char* msg,int line,const char* file);

int
_ITestResult_getFailureCount(ITestResult* pme);

int
_ITestResult_getRunCount(ITestResult* pme);


#endif /* __ACTTESTRESULT_PROTECTED_H__ */

