/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#ifndef __ACTTESTVECTOR_PROTECTED_H__
#define  __ACTTESTVECTOR_PROTECTED_H__

#include "acttestvector.h"

#ifdef	__cplusplus
extern "C" {
#endif

struct __ITestVec {
    ITestVecVtbl *pvt;
    uint32 m_cRef;
    ITest** body;
    int size;
    int capa;
};


ACTRESULT 
_ITestVec_new(ITestVec** ppobj);

void            
_ITestVec_ctor(ITestVec* pobj, ITestVecVtbl* pvt);

void 
_ITestVec_initVtbl(ITestVecVtbl* pvt);

ACTRESULT 
_ITestVec_init(ITestVec* pobj,int initial_capacity);

uint32         
_ITestVec_addRef(ITestVec* pobj);

uint32          
_ITestVec_release(ITestVec* pobj);

void            
_ITestVec_xtor(ITestVec* pobj);

ACTRESULT   
_ITestVec_queryInterface(ITestVec* pobj, ACTCLSID clsid, void ** ppNew);

ITestVec*   ITestVec_New(int initial_capacity);


//
// Test Vector Iterator
//

struct __ITestVecIterator {
    ITestVecIteratorVtbl *pvt;
    uint32  m_cRef;
    ITestVec* m_pTestVec_;
    int32 m_nCurrent_;
};


ACTRESULT 
_ITestVecIterator_new(ITestVecIterator** ppobj);

void            
_ITestVecIterator_ctor(ITestVecIterator* pobj, ITestVecIteratorVtbl* pvt);

void 
_ITestVecIterator_initVtbl(ITestVecIteratorVtbl* pvt);

ACTRESULT 
_ITestVecIterator_init(ITestVecIterator* pobj,  ITestVec* pTestVec);

uint32         
_ITestVecIterator_addRef(ITestVecIterator* pobj);

uint32          
_ITestVecIterator_release(ITestVecIterator* pobj);

void            
_ITestVecIterator_xtor(ITestVecIterator* pobj);

ACTRESULT   
_ITestVecIterator_queryInterface(ITestVecIterator* pobj, ACTCLSID clsid, void ** ppNew);


#ifdef __cplusplus
}
#endif

#endif /*  __ACTTESTVECTOR_PROTECTED_H__ */
