/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#include "actcommon.h"
#include "actunknown.h"
#include "actunknown_protected.h"
#include "acttest.h"
#include "acttestcase.h"
#include "acttestcase_protected.h"
#include "acttestresult.h"

///////////////////////////////////////////////////////////////////////////////
// ITestCase
static ITestResult* s_piTestResult;
static ITestCase* s_piTestCase;

ACTRESULT 
_ITestCase_new(ITestCase** ppobj)
{
    ACTRESULT result;
    ITestCase * pme;

    pme = (ITestCase*) act_malloc(sizeof(ITestCase) + sizeof(ITestCaseVtbl) );

    *ppobj = NULL;

    if(!pme)
    {
        return ACT_E_NOMEMORY;
    }
    
    _ITestCase_ctor(pme, (ITestCaseVtbl*)(pme+1));
    result = _ITestCase_init(pme,"", NULL, NULL, NULL);
    if(!result)
    {
        *ppobj = pme;
    }
    else
    {
        _ITestCase_xtor(pme);
        act_free(pme);        
    }

    *ppobj = (ITestCase*)pme;
    
    return result;
    
}

void 
_ITestCase_ctor(ITestCase* pme, ITestCaseVtbl* pvt)
{
    pme->m_cRef = 1;

    if(pvt)
    {
        pme->pvt = pvt;
        _ITestCase_initVtbl(pvt);
    }    
}


void 
_ITestCase_initVtbl(ITestCaseVtbl* pvt)
{
    pvt->addRef = _ITestCase_addRef;
    pvt->release = _ITestCase_release;
    pvt->queryInterface = _ITestCase_queryInterface;
    pvt->name = _ITestCase_name;
    pvt->run = _ITestCase_run;
    pvt->countTestCases = _ITestCase_countTestCases;
    pvt->getChildTestCount = _ITestCase_getChildTestCount;
    pvt->getChildTestAt = _ITestCase_getChildTestAt;
    pvt->findTest = _ITestCase_findTest;

    pvt->init = _ITestCase_init;
    pvt->setName = _ITestCase_setName;
    pvt->setRunTest = _ITestCase_setRunTest;
}


ACTRESULT 
_ITestCase_init(ITestCase* pobj, char * name, PFNSETUP setup, PFNTEARDWON teardown, PFNRUNTEST runTest)
{
    ITestCase * pme;
    pme = (ITestCase *) pobj;

    act_strncpy(pme->name, name, ACT_TEST_NAME_LENGTH);
    pme->setUp = setup;
    pme->tearDown = teardown;
    pme->runTest = runTest;
    
    return ACT_S_OK;
}


uint32 
_ITestCase_addRef(ITestCase* pobj)
{
    ITestCase* pme = (ITestCase*) pobj;
    return ++pme->m_cRef;
}


uint32 
_ITestCase_release(ITestCase* pobj)
{
    ITestCase* pme;
    uint32 cRef;

    pme = (ITestCase*) pobj;

    cRef = --pme->m_cRef;

    if(cRef == 0)
    {        
        _ITestCase_xtor(pme);
        act_free(pme);
    }
    
    return cRef;
}


void 
_ITestCase_xtor(ITestCase* pme)
{
}


ACTRESULT 
_ITestCase_queryInterface(ITestCase* pobj, ACTCLSID clsid, void ** ppNew)
{
    ACTRESULT result;

    result = ACT_E_CLASSNOTSUPPORT;
    *ppNew = 0;

    if (clsid == ACTIID_UNKNOWN  || clsid == ACTCLSID_UNKNOWN ||
        clsid == ACTIID_TEST     || clsid == ACTCLSID_TEST ||
        clsid == ACTIID_TESTCASE || clsid == ACTCLSID_TESTCASE)
    {
        *ppNew = pobj;
        _ITestCase_addRef(pobj);
        result = ACT_S_OK;
    }
    
    return result;
}

char* 
_ITestCase_name(ITestCase* pobj)
{
    ITestCase *pme;
    pme = (ITestCase*) pobj;

    return pme->name;
}

void 
_ITestCase_run(ITestCase* pme,ITestResult* pResult)
{
	ITestResult_startTest(pResult, (ITest*)pme);
	if (pme->setUp) {
		pme->setUp();
	}
	if (pme->runTest) {
		ITestResult* wr =s_piTestResult;	/*push*/
		ITestCase* ws = s_piTestCase;	/*push*/
		s_piTestResult = pResult;
		s_piTestCase = pme;
		pme->runTest();
		s_piTestResult = wr;	/*pop*/
		s_piTestCase = ws;	/*pop*/
	}
	if (pme->tearDown) {
		pme->tearDown();
	}
	ITestResult_endTest(pResult, (ITest*)pme);
}


int 
_ITestCase_countTestCases(ITestCase* pme)
{
	return 1;
}


int 
_ITestCase_getChildTestCount(ITestCase* pme)
{
	return 0;
}


ITest* 
_ITestCase_getChildTestAt(ITestCase* pme, int index)
{
	return NULL;
}


ITest* 
_ITestCase_findTest(ITestCase* pme,char * pszName)
{
    char * pszTestName;

    pszTestName = _ITestCase_name(pme);
    if ( act_strcmp(pszTestName, pszName) == 0)
    {
        return (ITest*) pme;
    }

    return NULL;
}

void
_ITestCase_setName(ITestCase* pobj, char * name)
{
    ITestCase *pme;
    pme = (ITestCase*) pobj;
    
    act_strncpy(pme->name,name, ACT_TEST_NAME_LENGTH);
}


void
_ITestCase_setRunTest(ITestCase* pobj, PFNRUNTEST runTest)
{
    ITestCase *pme;
    pme = (ITestCase*) pobj;

    pme->runTest = runTest;
}

    
void act_addFailure(const char *msg, long line, const char *file)
{	
	ITestResult_addFailure(s_piTestResult, (ITest*)s_piTestCase, (char*)msg, line, (char*)file);
}


///////////////////////////////////////////////////////////////////////////////
// ITestCase
#if 0
ITestCase* ITestCase_New(char *name, PFNSETUP setup, PFNTEARDWON teardown, PFNRUNTEST runTest)
{
    ITestCase * pme;

    pme = (ITestCase*) act_malloc(sizeof(ITestCase));
    return ITestCase_Ctor(pme, name, setup, teardown, runTest);
}


ITestCase* ITestCase_Ctor(ITestCase* pme, char *name, PFNSETUP setup, PFNTEARDWON teardown, PFNRUNTEST runTest)
{
	pme->pvt = &g_ITestVtbl;
    pme->m_cRef = 1;
	act_strncpy(pme->name, name, ACT_TEST_NAME_LENGTH);
	pme->setUp = setup;
	pme->tearDown = teardown;
	pme->runTest = runTest;

	return pme;	
}

static uint32     __ITestCase_AddRef(ITestCase *pme)
{
    return ++pme->m_cRef;
}


static void __ITestCase_Delete(ITestCase* pme)
{
    if(--pme->m_cRef == 0)
    {
        act_free(pme);
    }
}

static char* __ITestCase_name(ITestCase* pme)
{
	return pme->name;
}

static void __ITestCase_run(ITestCase* pme,ITestResult* pResult)
{
	ITestResult_startTest(pResult, (ITest*)pme);
	if (pme->setUp) {
		pme->setUp();
	}
	if (pme->runTest) {
		ITestResult* wr =s_pResult;	/*push*/
		ITestCase* ws = s_pTestCase;	/*push*/
		s_pResult = pResult;
		s_pTestCase = pme;
		pme->runTest();
		s_pResult = wr;	/*pop*/
		s_pTestCase = ws;	/*pop*/
	}
	if (pme->tearDown) {
		pme->tearDown();
	}
	ITestResult_endTest(pResult, (ITest*)pme);
}


static int __ITestCase_countTestCases(ITestCase* pme)
{
	return 1;
}


static int __ITestCase_getChildTestCount(ITestCase* pme)
{
	return 0;
}


ITest* __ITestCase_getChildTestAt(ITestCase* pme, int index)
{
	return NULL;
}


static ITest*     __ITestCase_findTest(ITestCase* pme,char * pszName)
{
    char * pszTestName;

    pszTestName = ITest_name(pme);
    if ( act_strcmp(pszTestName, pszName) == 0)
    {
        return (ITest*) pme;
    }

    return NULL;
}

void act_addFailure(const char *msg, long line, const char *file)
{	
	ITestResult_addFailure(s_pResult, (ITest*)s_pTestCase, (char*)msg, line, (char*)file);
}
#endif

