/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/


#include "actcommon.h"
#include "acttestfixturelist.h"
#include "acttestfixturelist_protected.h"
#include "acttestfixturelist_private.h"

#ifdef _WIN32
    #ifdef _DEBUG
    #define LIST_DEBUG
    #define MSG_PRINT(x) act_print(x)
    #else
    #define MSG_PRINT(x) 
    #endif
#else 
    #define MSG_PRINT(x) 
#endif 

//====================================================================
//
// Construction/Destruction
//
//====================================================================



/// Construction/Destruction


    /** Constructs an empty ordered list. */



ACTRESULT _ITestFixtureList_new(ITestFixtureList** ppobj)
{
    ACTRESULT result;
    ITestFixtureList* pme;

    pme = (ITestFixtureList*) act_malloc(sizeof(ITestFixtureList) + sizeof(ITestFixtureListVtbl));

    *ppobj = NULL;

    if(!pme)
    {
		MSG_PRINT("Fail no memory");
        
        return ACT_E_NOMEMORY;
    }
    
    _ITestFixtureList_ctor(pme, (ITestFixtureListVtbl*)(pme+1));
    result = _ITestFixtureList_init(pme);
    if(!result)
    {
        *ppobj = pme;
    }
    else
    {
        _ITestFixtureList_xtor(pme);
        act_free(pme);        
    }

    *ppobj = (ITestFixtureList*)pme;
    
    return result;
}


void _ITestFixtureList_ctor(ITestFixtureList* pobj, ITestFixtureListVtbl* pvt)
{    
    act_memset(pobj,0,sizeof(ITestFixtureList));
    pobj->m_cRef = 1;    

    if(pvt)
    {
        pobj->pvt = pvt;
        _ITestFixtureList_initVtbl(pvt);
    }    
}


void _ITestFixtureList_initVtbl(ITestFixtureListVtbl* pvt)
{
    pvt->addRef = _ITestFixtureList_addRef;
    pvt->release = _ITestFixtureList_release;
    pvt->queryInterface = _ITestFixtureList_queryInterface;
//
    pvt->getHead = List_getHead;
    pvt->getTail = List_getTail;
    pvt->removeHead = List_removeHead;
    pvt->removeTail = List_removeTail;
    pvt->addTail = List_addTail;
    pvt->removeAll = List_removeAll;
    pvt->getHeadPosition = List_getHeadPosition;
    pvt->getTailPosition = List_getTailPosition;
    pvt->getNext = List_getNext;
    pvt->getPrev = List_getPrev;
    pvt->getAt = List_getAt;
    pvt->SetAt = List_setAt;
    pvt->removeAt = List_removeAt;
    pvt->insertBefore = List_insertBefore;
    pvt->insertAfter = List_insertAfter;
    pvt->find = List_find;
    pvt->findIndex = List_findIndex;
    pvt->getNo = List_getNo;
    pvt->getCount = List_getCount;
    pvt->isEmpty = List_isEmpty;
    
}


ACTRESULT _ITestFixtureList_init(ITestFixtureList* pobj)
{
      return ACT_S_OK;
}


uint32 _ITestFixtureList_addRef(ITestFixtureList* pobj)
{
    ITestFixtureList* pme = (ITestFixtureList*) pobj;
    return ++pme->m_cRef;
}


uint32 _ITestFixtureList_release(ITestFixtureList* pobj)
{
    ITestFixtureList* pme;
    uint32 cRef;

    pme = (ITestFixtureList*) pobj;

    cRef = --pme->m_cRef;

    if(cRef == 0)
    {        
        _ITestFixtureList_xtor(pme);
        act_free(pme);
    }
    
    return cRef;
}


void _ITestFixtureList_xtor(ITestFixtureList* pobj)
{
    ITestFixtureList* pme;

    pme = (ITestFixtureList*) pobj;
    List_removeAll(pme, TRUE);  
}


ACTRESULT _ITestFixtureList_queryInterface(ITestFixtureList* pobj, ACTCLSID clsid, void ** ppNew)
{
    if(clsid == ACTCLSID_UNKNOWN ||
        clsid == ACTCLSID_TESTFIXTURELIST)
    {
        *ppNew = pobj;
        _ITestFixtureList_addRef(pobj);
        return ACT_S_OK;
    }
    *ppNew = 0;
    
    return ACT_E_CLASSNOTSUPPORT;
}


//====================================================================
//
//  Head/Tail Access
//
//====================================================================

/// Returns the head element of the list (cannot be empty).
static const ITestFixture* List_getHead(ITestFixtureList *pMe)
{
	if ( pMe->lpNodeHead == NULL )
	{
		return NULL;
	}
	return pMe->lpNodeHead->pData;
}

/// Returns the tail element of the list (cannot be empty).
static const ITestFixture* List_getTail(ITestFixtureList *pMe)
{
	if ( pMe->lpNodeTail == NULL )
	{
		return NULL;
	}
	return pMe->lpNodeTail->pData;	
}

/// Operations

//====================================================================
//
// Operations
//
//====================================================================

/// Removes the element from the head of the list.
/// Return Value: The Data pointer previously at the head of the list.
static ITestFixture* List_removeHead(ITestFixtureList *pMe, boolean bDataDelete) 
{
	ITestFixtureNode*		tmpNode;
	ITestFixture*	tmpData;
	if ( pMe->lpNodeHead == NULL )
		return NULL;

	tmpNode = pMe->lpNodeHead;
	tmpData = pMe->lpNodeHead->pData;

	pMe->lpNodeHead = tmpNode->pNext;
	if ( pMe->lpNodeHead != NULL )
	{
		pMe->lpNodeHead->pPrev = NULL;
	}
	else
	{
		pMe->lpNodeTail = NULL;
	}

	if ( bDataDelete ) 
	{
		if ( tmpData != NULL )
		{
			//act_free(tmpData);
            ITestFixture_release(tmpData);
			tmpData = NULL;
		}
	}
	act_free(tmpNode);

	pMe->nNodeCount--;
#ifdef LIST_DEBUG
	if ( pMe->nNodeCount < 0 )
	{
		MSG_PRINT("List_removeHead(pMe, BOOL bDataDelete) - pMe->nNodeCount is minus.");
	}
#endif
	return tmpData;
}


/// Removes the element from the tail of the list. 
static ITestFixture* List_removeTail(ITestFixtureList *pMe, boolean bDataDelete)
{
	ITestFixtureNode*		tmpNode;
	ITestFixture*	            tmpData;
	if ( pMe->lpNodeTail == NULL )
		return NULL;

	tmpNode = pMe->lpNodeTail;
	tmpData = pMe->lpNodeTail->pData;

	pMe->lpNodeTail = tmpNode->pPrev;
	if ( pMe->lpNodeTail != NULL )
	{
		pMe->lpNodeTail->pNext = NULL;
	}
	else
	{
		pMe->lpNodeHead = NULL;
	}

	if ( bDataDelete ) 
	{
		if ( tmpData != NULL )
		{
			//act_free(tmpData);
            ITestFixture_release(tmpData);
			tmpData = NULL;
		}
	}
	act_free(tmpNode);

	pMe->nNodeCount--;

#ifdef LIST_DEBUG
	if ( pMe->nNodeCount < 0 )
	{
		MSG_PRINT("List_removeTail(pMe, BOOL bDataDelete) - pMe->nNodeCount is minus.");
	}
#endif

	return tmpData;
}

/// Adds an element (or all the elements in another list) to the head of the list (makes a new head).
static ITestFixtureNode* List_addHead(ITestFixtureList *pMe, ITestFixture* pData)
{
	ITestFixtureNode* tmpNode = (ITestFixtureNode*)act_malloc(sizeof(ITestFixtureNode));
    tmpNode->pData = pData;
	tmpNode->pPrev = NULL;
	tmpNode->pNext = pMe->lpNodeHead;

    if ( pMe->lpNodeHead != NULL )
	    pMe->lpNodeHead->pPrev = tmpNode;
    else
        pMe->lpNodeTail = tmpNode;

	pMe->lpNodeHead = tmpNode;

	pMe->nNodeCount++;
#ifdef LIST_DEBUG
	if ( pMe->nNodeCount < 0 )
	{
		MSG_PRINT("List_addHead(pMe, ListItemPtr pData) - pMe->nNodeCount is minus.");
	}
#endif
	return pMe->lpNodeHead;
}

/// Adds an element (or all the elements in another list) to the tail of the list (makes a new tail).
static ITestFixtureNode* List_addTail(ITestFixtureList *pMe, ITestFixture* pData)
{
	ITestFixtureNode* tmpNode = (ITestFixtureNode*)act_malloc(sizeof(ITestFixtureNode));
    tmpNode->pData = pData;
	tmpNode->pNext = NULL;
	tmpNode->pPrev = pMe->lpNodeTail;

    if ( pMe->lpNodeTail != NULL )
        pMe->lpNodeTail->pNext = tmpNode;
    else
        pMe->lpNodeHead = tmpNode;
    
	pMe->lpNodeTail = tmpNode;

	pMe->nNodeCount++;
#ifdef LIST_DEBUG
	if ( pMe->nNodeCount < 0 )
	{
		MSG_PRINT("List_addTail(pMe, ListItemPtr pData) - pMe->nNodeCount is minus.");
	}
#endif	
 	return pMe->lpNodeTail;
}


/// Removes all the elements from this list.
// bDataDelete = FALSE ̸ Ʈ ͵ ݵ ڰ delete Ѵ.
static void List_removeAll(ITestFixtureList *pMe, boolean bDataDelete)
{
	ITestFixtureNode* Node = pMe->lpNodeHead;
	ITestFixtureNode* NextNode;

	while ( Node != NULL )
	{
		NextNode = Node->pNext;
		if ( Node != NULL )
		{
			if ( Node->pData != NULL && bDataDelete )
			{
				//act_free(Node->pData);
                ITestFixture_release(Node->pData);
				Node->pData = NULL;
			}
		}
		act_free(Node);
		Node = NextNode;
	}
	pMe->lpNodeHead = pMe->lpNodeTail = NULL;
	pMe->nNodeCount = 0;
}

/// Iteration

//====================================================================
//
// Iteration
//====================================================================

/// Returns the position of the head element of the list.
static const ITestFixtureNode* List_getHeadPosition(ITestFixtureList *pMe)
{
	return pMe->lpNodeHead;
}

/// Returns the position of the tail element of the list.
static const ITestFixtureNode* List_getTailPosition(ITestFixtureList *pMe)
{
	return pMe->lpNodeTail;
}

/// Gets the next element for iterating.
static const ITestFixture* List_getNext(ITestFixtureList *pMe, ITestFixtureNode** ppPosition)
{
    ITestFixture* pData;
    ITestFixtureNode* pNext;
    
    if ( pMe->lpNodeHead == NULL )
    {
        *ppPosition = NULL;
        pData = NULL;
    }
    
    if(ppPosition != NULL)
    {
        if( (*ppPosition)->pNext != NULL)
        {
            pData = (*ppPosition)->pData;
            pNext = (*ppPosition)->pNext;                
        }
        else
        {
            pData = (*ppPosition)->pData;
            pNext = NULL;
        }
    }
    else
    {
        pData = NULL;
        pNext = NULL;            
    }
    
    if(ppPosition != NULL)
    {
        *ppPosition = pNext;
    }
    
    return pData;
}

/// Gets the previous element for iterating.
static const ITestFixture* List_getPrev(ITestFixtureList *pMe, ITestFixtureNode** ppPosition)
{
    ITestFixture* pData;
    ITestFixtureNode* pPrev;
    
    if ( pMe->lpNodeHead == NULL )
    {
        *ppPosition = NULL;
        pData = NULL;
    }
    
    if(ppPosition != NULL)
    {
        if( (*ppPosition)->pPrev != NULL)
        {
            pData = (*ppPosition)->pData;
            pPrev = (*ppPosition)->pPrev;                
        }
        else
        {
            pData = (*ppPosition)->pData;
            pPrev = NULL;
        }
    }
    else
    {
        pData = NULL;
        pPrev = NULL;            
    }
    
    if(ppPosition != NULL)
    {
        *ppPosition = pPrev;
    }
    
    return pData;
}

/// Retrieval/Modification

//====================================================================
//
// Retrieval/Modification
//
//====================================================================

/// Gets the element at a given position.
static const ITestFixture* List_getAt(ITestFixtureList *pMe, ITestFixtureNode* position)
{
	if ( position == NULL ) return NULL;
	return position->pData;
}


/// Sets the element at a given position.
static void List_setAt(ITestFixtureList *pMe, ITestFixtureNode* pos, ITestFixture* newElement, boolean bDeleteData)
{
#ifdef LIST_DEBUG
	if ( pos == NULL )
	{
		MSG_PRINT("List_setAt(LPJNODE pos, JDataPtr newElement) - position is NULL.");
		return;
	}
#endif

	if ( bDeleteData )
	{
		act_free(pos->pData);
		pos->pData = NULL;
	}
	pos->pData = newElement;
}

/// Removes an element from this list, specified by position.
static void List_removeAt(ITestFixtureList *pMe, ITestFixtureNode* position, boolean bDeleteData)
{
	ITestFixtureNode* tmpNode = (ITestFixtureNode*) position;

#ifdef LIST_DEBUG
	if ( position == NULL )
	{
		MSG_PRINT("List_removeAt(LPJNODE position) - position is NULL.");
		return;
	}
#endif


	if ( tmpNode == pMe->lpNodeHead )
	{
        List_removeHead(pMe, bDeleteData);
        return;
	}
	if ( tmpNode == pMe->lpNodeTail )
	{
        List_removeTail(pMe, bDeleteData);
        return;
	}

	tmpNode->pPrev->pNext = tmpNode->pNext;
	tmpNode->pNext->pPrev = tmpNode->pPrev;

	if ( bDeleteData )
	{
		if ( tmpNode->pData != NULL )
		{
			//act_free(tmpNode->pData);
            ITestFixture_release(tmpNode->pData);
			tmpNode->pData = NULL;
		}
	}
	act_free(tmpNode);
	pMe->nNodeCount--;

#ifdef LIST_DEBUG
	if ( pMe->nNodeCount < 0 )
	{
		MSG_PRINT( "List_removeAt(LPJNODE position) - pMe->nNodeCount is minus.");
	}
#endif
}
//====================================================================
//
// Insertion
//
//====================================================================

/// Inserts a new element before a given position.
static ITestFixtureNode* List_insertBefore(ITestFixtureList *pMe, ITestFixtureNode* pos, ITestFixture* newElement)
{
	ITestFixtureNode* tmpNode;
	if ( pos == NULL ) return List_addHead(pMe, newElement);
	tmpNode = (ITestFixtureNode*)act_malloc(sizeof(ITestFixtureNode*));

	tmpNode->pData = newElement;
	tmpNode->pNext = pos;
	tmpNode->pPrev = pos->pPrev;

	if ( pos->pPrev == NULL )
	{
#ifdef LIST_DEBUG
		if ( pos != pMe->lpNodeHead )
		{
			MSG_PRINT("List::InsertBefore(LPJNODE pos, JDataPtr newElement) - pos != pMe->lpNodeHead.");
		}
#endif
		pMe->lpNodeHead = tmpNode;
	}
	else
	{
		pos->pPrev->pNext = tmpNode;
	}

	pos->pPrev = tmpNode;

	pMe->nNodeCount++;
#ifdef LIST_DEBUG
	if ( pMe->nNodeCount < 0 )
	{
		MSG_PRINT("List::InsertBefore(LPJNODE pos, JDataPtr newElement) - pMe->nNodeCount is minus.");
	}
#endif
	return tmpNode;
}

/// Inserts a new element after a given position.
static ITestFixtureNode* List_insertAfter(ITestFixtureList *pMe, ITestFixtureNode* pos, ITestFixture*newElement)
{
	ITestFixtureNode* tmpNode;
	if ( pos == NULL ) return List_addTail(pMe, newElement);
	tmpNode = (ITestFixtureNode*)act_malloc(sizeof(ITestFixtureNode));

	tmpNode->pData = newElement;
	tmpNode->pPrev = pos;
	tmpNode->pNext = pos->pNext;	

	if ( pos->pNext == NULL )
	{
#ifdef LIST_DEBUG
		if ( pos != pMe->lpNodeTail )
		{
			MSG_PRINT("List::InsertAfter(LPJNODE pos, JDataPtr newElement) - pos != pMe->lpNodeTail.");
		}
#endif
		pMe->lpNodeTail = tmpNode;
	}
	else
	{
		pos->pNext->pPrev = tmpNode;
	}

	pos->pNext = tmpNode;

	pMe->nNodeCount++;
#ifdef LIST_DEBUG
	if ( pMe->nNodeCount < 0 )
	{
		MSG_PRINT("List::InsertAfter(LPJNODE pos, JDataPtr newElement) - pMe->nNodeCount is minus.");
	}
#endif
	return tmpNode;
}

/// Searching

//====================================================================
//
// Searching
//
//====================================================================

/// Gets the position of an element specified by pointer value.
static const ITestFixtureNode* List_find(ITestFixtureList *pMe, ITestFixture* searchValue, ITestFixtureNode* startAfter)
{
	ITestFixtureNode* tmpNode;

       if( startAfter == NULL ) 
       {
            tmpNode =  (ITestFixtureNode*)pMe->lpNodeHead ;
        }
       else 
        {
           tmpNode =   (ITestFixtureNode*)startAfter;
       }

	for ( ; tmpNode != NULL; tmpNode = tmpNode->pNext )
	{
		if ( tmpNode->pData == searchValue ) return (ITestFixtureNode*)tmpNode;
	}
	return NULL;
}

/// Gets the position of an element specified by a zero-based index.
static const ITestFixtureNode* List_findIndex(ITestFixtureList *pMe, int nIndex)
{
	ITestFixtureNode* tmpNode;
	if ( nIndex >= pMe->nNodeCount || nIndex < 0 ) return NULL;

	tmpNode = pMe->lpNodeHead;
	while( nIndex-- )
	{
		tmpNode = tmpNode->pNext;
	}

	return (ITestFixtureNode*)tmpNode;
}


/// Gets the number of an element specified by pointer value.
static const int List_getNo(ITestFixtureList *pMe, ITestFixture* searchValue, ITestFixtureNode* startAfter)
{
    	int nNo = 0;
	ITestFixtureNode* tmpNode;
       if( startAfter == NULL ) 
       {
            tmpNode =  (ITestFixtureNode*)pMe->lpNodeHead ;
        }
       else 
        {
           tmpNode =   (ITestFixtureNode*)startAfter;
       }

	for ( ; tmpNode != NULL; tmpNode = tmpNode->pNext )
	{
        nNo++;
		if ( tmpNode->pData == searchValue ) return nNo;
	}
	return 0;
}


//====================================================================
//
// Status
//
//====================================================================

/// Returns the number of elements in this list.
static int List_getCount(ITestFixtureList *pMe)
{
	return pMe->nNodeCount;
}


/// Tests for the empty list condition (no elements).
/// Nonzero if this list is empty; otherwise 0.
static boolean List_isEmpty(ITestFixtureList *pMe)
{
	return (pMe->nNodeCount == 0);
}
