/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#include "actcommon.h"
#include "actunknown.h"
#include "acttest.h"
#include "acttestlist.h"
#include "acttestlistener.h"
#include "acttestresult.h"
#include "acttestresult_protected.h"
#include "acttestrunner.h"
#include "acttestrunner_private.h"

static ITestListener* s_piTestListener;
static ITestResult* s_piTestResult;
static ITest* s_piRootTest;

ITest* _act_getRootTest()
{
    return s_piRootTest;
}

void __act_setRootTest(ITest* pRootTest)
{
    s_piRootTest = pRootTest;
}

///////////////////////////////////////////////////////////////////////////////

ACTRESULT 
_ITestRunner_new(ITestRunner** ppobj)
{
    ACTRESULT result;
    ITestRunner *pme;

    pme = act_malloc(sizeof(ITestRunner)+sizeof(ITestRunnerVtbl));

    if(!pme)
    {
        return ACT_E_NOMEMORY;
    }

    _ITestRunner_ctor(pme, (ITestRunnerVtbl*)(pme+1));    
    result = _ITestRunner_init(pme);
    if(!result)
    {
        *ppobj = pme;
    }
    else
    {
        _ITestRunner_xtor(pme);
        act_free(pme);        
    }

    *ppobj = (ITestRunner*)pme;
    
    return result;
    
}

void 
_ITestRunner_ctor(ITestRunner* pme, ITestRunnerVtbl* pvt)
{
    pme->m_cRef = 1;

    if(pvt)
    {
        pme->pvt = pvt;
        _ITestRunner_initVtbl(pvt);
    }    
}


void 
_ITestRunner_initVtbl(ITestRunnerVtbl* pvt)
{
    pvt->addRef = _ITestRunner_addRef;
    pvt->release = _ITestRunner_release;
    pvt->queryInterface = _ITestRunner_queryInterface;

    pvt->start = _ITestRunner_start;
    pvt->addTest = _ITestRunner_addTest;
    pvt->runTest = _ITestRunner_runTest;
    pvt->end = _ITestRunner_end;
}

ACTRESULT 
_ITestRunner_init(ITestRunner* pobj)
{
    ITestRunner * pme;
    pme = (ITestRunner *) pobj;

    act_createInstance(ACTCLSID_TESTLIST, (void**) &pme->m_lstTest__);
    act_createInstance(ACTCLSID_TESTRESULT, (void**) &s_piTestResult);
    return ACT_S_OK;
}


uint32 
_ITestRunner_addRef(ITestRunner* pobj)
{
    ITestRunner* pme = (ITestRunner*) pobj;
    return ++pme->m_cRef;
}


uint32 
_ITestRunner_release(ITestRunner* pobj)
{
    ITestRunner* pme;
    uint32 cRef;

    pme = (ITestRunner*) pobj;

    cRef = --pme->m_cRef;

    if(cRef == 0)
    {        
        _ITestRunner_xtor(pme);
        act_free(pme);
    }
    
    return cRef;
}


void 
_ITestRunner_xtor(ITestRunner* pme)
{
   ITestList_release(pme->m_lstTest__);
   ITestResult_release(s_piTestResult);
}


ACTRESULT 
_ITestRunner_queryInterface(ITestRunner* pobj, ACTCLSID clsid, void ** ppNew)
{
    ACTRESULT result;

    result = ACT_E_CLASSNOTSUPPORT;
    *ppNew = 0;

    if (clsid == ACTCLSID_UNKNOWN ||
        clsid == ACTCLSID_TESTRUNNER)
    {
        *ppNew = pobj;
        _ITestRunner_addRef(pobj);
        result = ACT_S_OK;
    }
    
    return result;
}


void _ITestRunner_start(ITestRunner* pme)
{
    act_createInstance(ACTCLSID_TESTLISTENER, (void**) &s_piTestListener);

    ITestResult_init(s_piTestResult, (ITestListener*) s_piTestListener);
}


void _ITestRunner_addTest(ITestRunner* pme, ITest* test)
{
    ITestList_addTail(pme->m_lstTest__, test);
}

void _ITestRunner_runTest(ITestRunner* pMe)
{
    ITestNode* pNode;
    ITest* test;
    int nCount;
    int index;

    pNode = (ITestNode*) ITestList_getHeadPosition(pMe->m_lstTest__);
    nCount = ITestList_getCount(pMe->m_lstTest__);
    for(index = 0; index < nCount; index++)
    {
        test = (ITest*) ITestList_getNext(pMe->m_lstTest__, &pNode);
        s_piRootTest = test;
        ITest_run(test, s_piTestResult);
    }
}


void _ITestRunner_end(ITestRunner* pme)
{
    char buf[16];
    if (s_piTestResult->failureCount) {
        act_print("\nrun ");
        act_itoa(s_piTestResult->runCount, buf, 10);
        act_print(buf);
        act_print(" failures ");
        act_itoa(s_piTestResult->failureCount, buf, 10);
        act_print(buf);
        act_print("\n");
    } else {
        act_print("\nOK (");
        act_itoa(s_piTestResult->runCount, buf, 10);
        act_print(buf);
        act_print(" tests)\n");
    }
    if(s_piTestListener)
    {
        ITestListener_release(s_piTestListener);
    }
    
}
