/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#include "actcommon.h"
#include "actunknown.h"
#include "acttest.h"

#include "acttestsuite_private.h"

///////////////////////////////////////////////////////////////////////////////
ACTRESULT 
_ITestSuite_new(ITestSuite** ppobj)
{
    ACTRESULT result;
    ITestSuite * pme;

    pme = (ITestSuite*) act_malloc(sizeof(ITestSuite) + sizeof(ITestSuiteVtbl) );

    *ppobj = NULL;

    if(!pme)
    {
        return ACT_E_NOMEMORY;
    }
    
    _ITestSuite_ctor(pme, (ITestSuiteVtbl*)(pme+1));
    result = _ITestSuite_init(pme,"");
    if(!result)
    {
        *ppobj = pme;
    }
    else
    {
        _ITestSuite_xtor(pme);
        act_free(pme);        
    }

    *ppobj = (ITestSuite*)pme;
    
    return result;
    
}

void 
_ITestSuite_ctor(ITestSuite* pme, ITestSuiteVtbl* pvt)
{
    pme->m_cRef = 1;

    if(pvt)
    {
        pme->pvt = pvt;
        _ITestSuite_initVtbl(pvt);
    }    
}


void 
_ITestSuite_initVtbl(ITestSuiteVtbl* pvt)
{
    pvt->addRef = _ITestSuite_addRef;
    pvt->release = _ITestSuite_release;
    pvt->queryInterface = _ITestSuite_queryInterface;
    pvt->name = _ITestSuite_name;
    pvt->run = _ITestSuite_run;
    pvt->countTestCases = _ITestSuite_countTestCases;
    pvt->getChildTestCount = _ITestSuite_countTestCases;
    pvt->getChildTestAt = _ITestSuite_getChildTestAt;
    pvt->findTest = _ITestSuite_findTest;

    pvt->addTest = _ITestSuite_addTest;
    pvt->findName = _ITestSuite_findName;
    pvt->init = _ITestSuite_init;
}


ACTRESULT 
_ITestSuite_init(ITestSuite* pobj, char * name)
{
    ITestSuite * pme;
    pme = (ITestSuite *) pobj;

    act_strncpy(pme->name, name, ACT_TEST_NAME_LENGTH);
    act_createInstance(ACTCLSID_TESTLIST, (void**) &pme->m_lstTest__);

    return ACT_S_OK;
}


uint32 
_ITestSuite_addRef(ITestSuite* pobj)
{
    ITestSuite* pme = (ITestSuite*) pobj;
    return ++pme->m_cRef;
}


uint32 
_ITestSuite_release(ITestSuite* pobj)
{
    ITestSuite* pme;
    uint32 cRef;

    pme = (ITestSuite*) pobj;

    cRef = --pme->m_cRef;

    if(cRef == 0)
    {        
        _ITestSuite_xtor(pme);
        act_free(pme);
    }
    
    return cRef;
}


void 
_ITestSuite_xtor(ITestSuite* pme)
{
    ITestList_release(pme->m_lstTest__);
}


ACTRESULT 
_ITestSuite_queryInterface(ITestSuite* pobj, ACTCLSID clsid, void ** ppNew)
{
    ACTRESULT result;

    result = ACT_E_CLASSNOTSUPPORT;
    *ppNew = 0;

    if (clsid == ACTCLSID_UNKNOWN ||
        clsid == ACTCLSID_TEST ||
        clsid == ACTCLSID_TESTSUITE)
    {
        *ppNew = pobj;
        _ITestSuite_addRef(pobj);
        result = ACT_S_OK;
    }
    
    return result;
}


char* _ITestSuite_name(ITestSuite* self)
{
    return self->name;
}

void _ITestSuite_run(ITestSuite* self,ITestResult* result)
{
    ITest* test;
    ITestNode* pNode;
    
    int i;
    int numberOfTests; 
    
    
    if(self->m_lstTest__)
    {
        numberOfTests = ITestList_getCount(self->m_lstTest__);
        pNode = (ITestNode*) ITestList_getHeadPosition(self->m_lstTest__);
        
        for(i = 0; i < numberOfTests; i++)
        {
            test = (ITest*) ITestList_getNext(self->m_lstTest__, &pNode);
            ITest_run(test, result);
        }
    }
}

int _ITestSuite_countTestCases(ITestSuite* self)
{
    ITest* test;
    ITestNode* pNode;
    
    int count = 0;
    int i;
    int numberOfTests; 
    
    if(self->m_lstTest__)
    {
        numberOfTests = ITestList_getCount(self->m_lstTest__);
        pNode = (ITestNode*) ITestList_getHeadPosition(self->m_lstTest__);
        
        for(i = 0; i < numberOfTests; i++)
        {
            test = (ITest*) ITestList_getNext(self->m_lstTest__, &pNode);
            count += ITest_countTestCases(test);
        }
    }
    
    return count;
}

int      _ITestSuite_getChildTestCount(ITestSuite* self)
{
    return ITestList_getCount(self->m_lstTest__);
}


ITest*      _ITestSuite_getChildTestAt(ITestSuite* pme, int index)
{
    ITestNode * pNode;

    pNode = (ITestNode *)ITestList_findIndex(pme->m_lstTest__, index);
    return (ITest *)ITestList_getAt(pme->m_lstTest__, pNode);
}


ITest*      _ITestSuite_findTest(ITestSuite* self, char *pszName)
{
    char* pszTestName;
    ITest* test;
    ITestNode* pNode;
    
    int i;
    int numberOfTests; 
    
    pszTestName = ITestSuite_name(self);
    if( act_strcmp(pszTestName, pszName) == 0)
    {
        return (ITest*)self;
    }
    
    if(self->m_lstTest__)
    {
        numberOfTests = ITestList_getCount(self->m_lstTest__);
        pNode = (ITestNode*) ITestList_getHeadPosition(self->m_lstTest__);
        
        for(i = 0; i < numberOfTests; i++)
        {
            test = (ITest*) ITestList_getNext(self->m_lstTest__, &pNode);
            pszTestName = ITest_name(test);
            if( act_strcmp(pszTestName, pszName) == 0)
            {
                return test;
            }
        }
    }    
    return NULL;
}
void _ITestSuite_addTest(ITestSuite* pMe, ITest* pITest)
{
    //    pMe->m_lstTest;
    ITestList_addTail(pMe->m_lstTest__, pITest);
}


ITest* _ITestSuite_findName(ITestSuite* self,char * pszName)
{
    ITest* test;
    ITestNode* pNode;
    char * pszTestName;
    
    int count = 0;
    int i;
    int numberOfTests; 
    
    if(self->m_lstTest__)
    {
        numberOfTests = ITestList_getCount(self->m_lstTest__);
        pNode = (ITestNode*) ITestList_getHeadPosition(self->m_lstTest__);
        
        for(i = 0; i < numberOfTests; i++)
        {
            test = (ITest*) ITestList_getNext(self->m_lstTest__, &pNode);
            pszTestName = ITest_name(test);
            
            if(pszTestName && act_strcmp(pszName, pszTestName) == 0)
            {
                return test;
            }
        }
   }
    
    return NULL;
}
