/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

// ActiveTest.h: interface for the ActiveTest class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ACTIVETEST_H__D4DE542D_4BE8_4099_BEC9_A296CBC08FEC__INCLUDED_)
#define AFX_ACTIVETEST_H__D4DE542D_4BE8_4099_BEC9_A296CBC08FEC__INCLUDED_

#include <afxmt.h>

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "act.h"
#include "acttest_protected.h"

/** 
 * A Microsoft-specific active test
 *
 * An active test manages its own
 * thread of execution.  This one 
 * is very simple and only sufficient
 * for the limited use we put it through
 * in the TestRunner.  It spawns a thread
 * on run (TestResult *) and signals
 * completion of the test.
 *
 * We assume that only one thread 
 * will be active at once for each
 * instance.
 *
 */
class ActiveTest : public ITest 
{
public:
	ActiveTest(ITest* test);
	virtual ~ActiveTest();
    
    void run(ITestResult* result);

protected:
  ITest *m_test;
  HANDLE m_threadHandle;
  CEvent m_runCompleted;
  ITestResult *m_currentTestResult;
  
  void run();
  void setTestResult( ITestResult *result );
  static UINT threadFunction( LPVOID thisInstance );
};

#endif // !defined(AFX_ACTIVETEST_H__D4DE542D_4BE8_4099_BEC9_A296CBC08FEC__INCLUDED_)
