/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

// TestRunnerModel.cpp: implementation of the TestRunnerModel class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include <algorithm>
//#include <stdexcept>
//#include "acttestrunnermfc.h"
#include "TestRunnerModel.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

const CString TestRunnerModel::settingKey( _T("ACT") );
const CString TestRunnerModel::settingMainDialogKey( _T( "MainDialog" ) );
const CString TestRunnerModel::settingBrowseDialogKey( _T( "BrowseDialog" ) );

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

TestRunnerModel::TestRunnerModel(ITest *rootTest) :
     m_rootTest( rootTest )
{
}


TestRunnerModel::~TestRunnerModel()
{
}

const TestRunnerModel::History &
TestRunnerModel::history() const
{
  return m_history;
}

template<class SequenceType, class ValueType>
void
removeFromSequence( SequenceType &sequence, 
                    const ValueType &valueToRemove )
{
   for ( unsigned int index =0; index < sequence.size(); ++index )
   {
      if ( sequence[ index ] == valueToRemove )
         sequence.erase( sequence.begin() + index );
   }
}

void 
TestRunnerModel::selectHistoryTest( ITest *test )
{
   ::removeFromSequence( m_history, test );
   
  if ( test != NULL )
    m_history.push_front( test );
}


ITest *
TestRunnerModel::selectedTest() const
{
  if ( m_history.size() > 0 )
    return m_history[0];
  return NULL;
}


void 
TestRunnerModel::loadSettings(Settings & s)
{
  CWinApp *app = AfxGetApp();
  ASSERT( app != NULL );

  int autorun = app->GetProfileInt( _T("ACT"),
                                    _T("AutorunAtStartup"),
                                    1 );
  s.autorunOnLaunch = (autorun == 1);

  s.col_1 = app->GetProfileInt( _T("ACT"), _T("Col_1"), 40 );
  s.col_2 = app->GetProfileInt( _T("ACT"), _T("Col_2"), 40 );
  s.col_3 = app->GetProfileInt( _T("ACT"), _T("Col_3"), 40 );
  s.col_4 = app->GetProfileInt( _T("ACT"), _T("Col_4"), 40 );

  loadHistory();
}


void 
TestRunnerModel::loadHistory()
{
  m_history.clear();
  int idx = 1;
  do
  {
    CString testName = loadHistoryEntry( idx++ );
    if ( testName.IsEmpty() )
      break;

    try
    {
      m_history.push_back( NULL      
          /*m_rootTest->findTest( toAnsiString(testName ) ) */);
    }
    catch ( std::invalid_argument &)
    {
    }
  }
  while ( true );
}


CString
TestRunnerModel::loadHistoryEntry( int idx )
{
  CWinApp *app = AfxGetApp();
  ASSERT( app != NULL );

  return app->GetProfileString( _T("ACT"), getHistoryEntryName( idx ) );
}


void 
TestRunnerModel::saveSettings( const Settings & s )
{
  CWinApp *app = AfxGetApp();
  ASSERT( app != NULL );

  int autorun = s.autorunOnLaunch ? 1 : 0;
  app->WriteProfileInt( _T("ACT"), _T("AutorunAtStartup"), autorun );

  app->WriteProfileInt( _T("ACT"), _T("Col_1"),	 s.col_1 );
  app->WriteProfileInt( _T("ACT"), _T("Col_2"),	 s.col_2 );
  app->WriteProfileInt( _T("ACT"), _T("Col_3"),	 s.col_3 );
  app->WriteProfileInt( _T("ACT"), _T("Col_4"),	 s.col_4 );

  int idx = 1;
  for ( History::const_iterator it = m_history.begin(); 
        it != m_history.end(); 
        ++it , ++idx )
  {
    ITest *test = *it;
#if 0
    saveHistoryEntry( idx, test->getName().c_str() );
#endif
  }
}


void 
TestRunnerModel::saveHistoryEntry( int idx, 
                                   CString testName )
{
  CWinApp *app = AfxGetApp();
  ASSERT( app != NULL );

  app->WriteProfileString( _T("CppUnit"),
                           getHistoryEntryName( idx ),
                           testName );
}


CString
TestRunnerModel::getHistoryEntryName( int idx ) const
{
  CString entry;
  entry.Format( _T("HistoryTest%d"), idx );
  return entry;
}


ITest *
TestRunnerModel::rootTest()
{
  return m_rootTest;
}


void 
TestRunnerModel::setRootTest( ITest *test )
{
  m_rootTest = test;
}


ITest * 
TestRunnerModel::findTestByName( CString name ) const
{
  return findTestByNameFor( name, m_rootTest );
}


ITest * 
TestRunnerModel::findTestByNameFor( const CString &name, 
                                    ITest *test ) const
{
    CString strTestName;

    strTestName = ITest_name(test);
  if ( name == strTestName )
    return test;

   ITestSuite *suite = (ITestSuite*) test;

   if( suite == NULL)
       return NULL;

   ITest *testFound = ITestSuite_findName(suite, (char *)(LPCTSTR)strTestName);
    return testFound;
    //ITestList* tests = ITestSuite_getTests(suite);
//    ITestList_AddRef(tests);

//    ITestList_Delete(tests);
#if 0
  CPPUNIT_NS::TestSuite *suite = dynamic_cast<CPPUNIT_NS::TestSuite *>(test);
  if ( suite == NULL )
    return NULL;

  const std::vector<ITest *> &tests = suite->getTests();
  for ( std::vector<ITest *>::const_iterator it = tests.begin(); 
        it != tests.end(); 
        ++it )
  {
    ITest *testFound = findTestByNameFor( name, *it );
    if ( testFound != NULL )
      return testFound;
  }
#endif

  return NULL;
}


// Utility method, should be moved somewhere else...
std::string 
TestRunnerModel::toAnsiString( const CString &text )
{
#ifdef _UNICODE
  int bufferLength = ::WideCharToMultiByte( CP_THREAD_ACP, 0, 
                                            text, text.GetLength(),
                                            NULL, 0, NULL, NULL ) +1;
  char *ansiString = new char[bufferLength];
  ::WideCharToMultiByte( CP_THREAD_ACP, 0, 
                         text, text.GetLength(),
                         ansiString, bufferLength, 
                                            NULL,
                                            NULL );

  std::string str( ansiString, bufferLength-1 );
  delete[] ansiString;

  return str;
#else
  return std::string( (LPCTSTR)text );
#endif
}
