/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

// TreeHierarchyDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "TreeHierarchyDlg.h"
#include "TestRunnerModel.h"
#include "ResourceLoaders.h"
#include <algorithm>


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// TreeHierarchyDlg dialog


TreeHierarchyDlg::TreeHierarchyDlg(CWnd* pParent /*=NULL*/)
	: cdxCDynamicDialog(TreeHierarchyDlg::IDD, pParent)
  , m_selectedTest( NULL )
{
  ModifyFlags( flSWPCopyBits, 0 );      // anti-flickering option for resizing

	//{{AFX_DATA_INIT(TreeHierarchyDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void 
TreeHierarchyDlg::DoDataExchange(CDataExchange* pDX)
{
	cdxCDynamicDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(TreeHierarchyDlg)
	DDX_Control(pDX, IDC_TREE_TEST, m_treeTests);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(TreeHierarchyDlg, cdxCDynamicDialog)
	//{{AFX_MSG_MAP(TreeHierarchyDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// TreeHierarchyDlg message handlers

void 
TreeHierarchyDlg::setRootTest(ITest *test)
{
    m_rootTest = test;
}


BOOL 
TreeHierarchyDlg::OnInitDialog() 
{
	cdxCDynamicDialog::OnInitDialog();
	
  fillTree();
  initializeLayout();
  RestoreWindowPosition( TestRunnerModel::settingKey, 
                         TestRunnerModel::settingBrowseDialogKey );
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


void 
TreeHierarchyDlg::initializeLayout()
{
  // see DynamicWindow/doc for documentation
  AddSzControl( IDC_TREE_TEST, mdResize, mdResize );
  AddSzControl( IDOK, mdRepos, mdNone );
  AddSzControl( IDCANCEL, mdRepos, mdNone );
}


void 
TreeHierarchyDlg::fillTree()
{
  VERIFY( m_imageList.Create( _T("ACT_TEST_RUNNER_IDB_TEST_TYPE"), 
                              16, 1, RGB( 255,0,255 ) ) );

  m_treeTests.SetImageList( &m_imageList, TVSIL_NORMAL );

  HTREEITEM hSuite = addTest( m_rootTest, TVI_ROOT );
  m_treeTests.Expand( hSuite, TVE_EXPAND );
}


HTREEITEM 
TreeHierarchyDlg::addTest(ITest *test, 
                          HTREEITEM hParent)
{
int testType = isSuite( test ) ? imgSuite : imgUnitTest;
  HTREEITEM hItem = m_treeTests.InsertItem( ITest_name(test),
                                            testType,
                                            testType,
                                            hParent );
  if ( hItem != NULL )
  {
    VERIFY( m_treeTests.SetItemData( hItem, (DWORD)test ) );
    if ( isSuite( test ) )
      addTestSuiteChildrenTo( test, hItem );
  }
return hItem;
}


void 
TreeHierarchyDlg::addTestSuiteChildrenTo(ITest *suite, 
                                         HTREEITEM hItemSuite)
{
  Tests tests;
  int childIndex = 0;
  for ( ; childIndex < ITest_getChildTestCount(suite); ++childIndex )
    tests.push_back( ITest_getChildTestAt(suite, childIndex ) );
  sortByName( tests );

  for ( childIndex = 0; childIndex < ITest_getChildTestCount(suite); ++childIndex )
    addTest( ITest_getChildTestAt(suite, childIndex ), hItemSuite );
}

bool 
TreeHierarchyDlg::isSuite(ITest *test)
{
  return ( ITest_getChildTestCount(test) > 0 || // suite with test
           ITest_countTestCases(test) == 0); // empty suite
}


struct PredSortTest
{    
  bool operator()( ITest *test1, ITest *test2 ) const
  {
    bool isTest1Suite = TreeHierarchyDlg::isSuite( test1 );
    bool isTest2Suite = TreeHierarchyDlg::isSuite( test2 );
    if ( isTest1Suite  &&  !isTest2Suite )
      return true;
    if ( isTest1Suite  &&  isTest2Suite )
    {        
        CString str1 = ITest_name(test1);
        CString str2 = ITest_name(test2);
        return str1 < str2;
   }
    return false;
  }
};

void 
TreeHierarchyDlg::sortByName(Tests &tests) const
{
  std::stable_sort( tests.begin(), tests.end(), PredSortTest() );
}


void 
TreeHierarchyDlg::OnOK() 
{
  ITest *test = findSelectedTest();
  if ( test == NULL )
  {
    AfxMessageBox( loadCString(IDS_ERROR_SELECT_TEST), MB_OK );
    return;
  }
	
  m_selectedTest = test;
  storeDialogBounds();
	cdxCDynamicDialog::OnOK();
}


void 
TreeHierarchyDlg::OnCancel() 
{
  storeDialogBounds();
	cdxCDynamicDialog::OnCancel();
}


ITest* 
TreeHierarchyDlg::findSelectedTest()
{
  HTREEITEM hItem = m_treeTests.GetSelectedItem();
  if ( hItem != NULL )
  {
    DWORD data;
    VERIFY( data = m_treeTests.GetItemData( hItem ) );
    return (ITest *)( data );
  }
  return NULL;
}


ITest* 
TreeHierarchyDlg::getSelectedTest() const
{
  return m_selectedTest;
}


void 
TreeHierarchyDlg::storeDialogBounds()
{
  StoreWindowPosition( TestRunnerModel::settingKey, 
                       TestRunnerModel::settingBrowseDialogKey );
}
