/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#include "stdafx.h"
#include "resource.h"
#include "actMfcTestRunnerDllMain.h"
#include "TestRunnerDlg.h"

#include "act.h"
#include "acttestlistenermfc.h"
#include "acttestlistenermfc_protected.h"

#if 0
//static void __ITestListenerMfc_startTest(ITestListenerMfc* pme,ITest* test);
//static void __ITestListenerMfc_endTest(ITestListenerMfc* pme,ITest* test);
//static void __ITestListenerMfc_addFailure(ITestListenerMfc* pme,ITest* test,char* msg,int line,char* file);

static const ITestListenerVtbl g_ITestListenerVtbl = {
    (TestListenerStartTestCallBack)	__ITestListenerMfc_startTest,
        (TestListenerEndTestCallBack)	__ITestListenerMfc_endTest,
        (TestListenerAddFailureCallBack)	__ITestListenerMfc_addFailure,
};

	
ITestListenerMfc * ITestListenerMfc_New(TestRunnerDlg *pDlg)
{
	ITestListenerMfc *pme;

	pme = (ITestListenerMfc *)act_malloc(sizeof(ITestListenerMfc));

	((ITestListener*)pme)->pvt = (ITestListenerVtbl*)&g_ITestListenerVtbl;
    pme->m_pDlg = pDlg;

    return pme;
}


void ITestListenerMfc_delete(ITestListenerMfc *pme)
{
    if(pme)
    {
        act_free(pme);
    }
}
#endif


ACTRESULT _ITestListenerMfc_new(ITestListenerMfc** ppobj)
{
    ACTRESULT result;
    ITestListenerMfc *pme;

    pme = (ITestListenerMfc*) act_malloc(sizeof(ITestListenerMfc)+sizeof(ITestListenerMfcVtbl));

    if(!pme)
    {
        return ACT_E_NOMEMORY;
    }

    _ITestListenerMfc_ctor(pme, (ITestListenerMfcVtbl*)(pme+1));    
    result = _ITestListenerMfc_init(pme,NULL);
    if(!result)
    {
        *ppobj = pme;
    }
    else
    {
        _ITestListenerMfc_xtor(pme);
        act_free(pme);        
    }

    *ppobj = (ITestListenerMfc*)pme;
    
    return result;
    
}

void 
_ITestListenerMfc_ctor(ITestListenerMfc* pme, ITestListenerMfcVtbl* pvt)
{
    pme->m_cRef = 1;    

    if(pvt)
    {
        pme->pvt = pvt;
        _ITestListenerMfc_initVtbl(pvt);
    }    
}

void 
_ITestListenerMfc_initVtbl(ITestListenerMfcVtbl* pvt)
{
    pvt->addRef = _ITestListenerMfc_addRef;
    pvt->release = _ITestListenerMfc_release;
    pvt->queryInterface = _ITestListenerMfc_queryInterface;

    pvt->startTest = (TestListenerStartTestCallBack) _ITestListenerMfc_startTest;
    pvt->endTest = (TestListenerEndTestCallBack) _ITestListenerMfc_endTest;
    pvt->addFailure = (TestListenerAddFailureCallBack) _ITestListenerMfc_addFailure;
    pvt->init = _ITestListenerMfc_init;
}


ACTRESULT 
_ITestListenerMfc_init(ITestListenerMfc* pobj, TestRunnerDlg * pDlg)
{
    ITestListenerMfc * pme;
    pme = (ITestListenerMfc *) pobj;

    pme->m_pDlg = pDlg;
    
    return ACT_S_OK;
}

uint32 
_ITestListenerMfc_addRef(ITestListenerMfc* pobj)
{
    ITestListenerMfc* pme = (ITestListenerMfc*) pobj;
    return ++pme->m_cRef;
}

uint32 
_ITestListenerMfc_release(ITestListenerMfc* pobj)
{
    ITestListenerMfc* pme;
    uint32 cRef;

    pme = (ITestListenerMfc*) pobj;

    cRef = --pme->m_cRef;

    if(cRef == 0)
    {        
        _ITestListenerMfc_xtor(pme);
        act_free(pme);
    }
    
    return cRef;
}


void 
_ITestListenerMfc_xtor(ITestListenerMfc* pme)
{
}


ACTRESULT 
_ITestListenerMfc_queryInterface(ITestListenerMfc* pobj, ACTCLSID clsid, void ** ppNew)
{
    ACTRESULT result;

    result = ACT_E_CLASSNOTSUPPORT;
    *ppNew = 0;

    if (clsid == ACTCLSID_UNKNOWN ||
        clsid == ACTIID_TESTLISTENER || clsid == ACTCLSID_TESTLISTENER ||
        clsid == ACTCLSID_TESTLISTENERMFC)
    {
        *ppNew = pobj;
        _ITestListenerMfc_addRef(pobj);
        result = ACT_S_OK;
    }
    
    return result;
}


void 
_ITestListenerMfc_startTest(ITestListenerMfc* pme,ITest* test)
{
    pme->m_pDlg->startTest(pme, test);
}

void 
_ITestListenerMfc_endTest(ITestListenerMfc* pme,ITest* test)
{

    pme->m_pDlg->endTest(pme, test);
}

void 
_ITestListenerMfc_addFailure(ITestListenerMfc* pme,ITest* test,char* msg,int line,char* file)
{
    pme->m_pDlg->addFailure(pme, test, msg, line, file);
}

