/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#include "act.h"
#include "actTests.h"

#ifdef ACT_ASSERT_TESTS

static void setUp(void)
{
}

static void tearDown(void)
{
}

static void verify(ITestCase* test)
{
	ITestResult* pResult;

    ACT_TESTRESULT_NEW(pResult, NULL);

	ITest_run((ITest*)test,pResult);
	//test->isa->run(test,&result);

	if (ITestResult_getFailureCount(pResult) == 0)
	{
		ACT_TEST_FAIL("fail");
	}
}

static void assert_equal_string_runTest(void)
{
	ACT_TEST_ASSERT_EQUAL_STRING("123","456");
}

static void assert_equal_int_runTest(void)
{
	ACT_TEST_ASSERT_EQUAL_INT(123,456);
}

static void assert_null_runTest(void)
{
	char *p="";
	ACT_TEST_ASSERT_NULL(p);
}

static void assert_not_null_runTest(void)
{
	char *p=NULL;
	ACT_TEST_ASSERT_NOT_NULL(p);
}

static void assert_message_runTest(void)
{
	ACT_TEST_ASSERT_MESSAGE(0,"0");
}

static void assert_runTest(void)
{
	ACT_TEST_ASSERT(0);
}

static void testASSERT_EQUAL_STRING(void)
{
    ITestCase* pTCase;
    ACT_TESTCASE_NEW(pTCase,"assert_equal_string",NULL,NULL,assert_equal_string_runTest);

    verify(pTCase);

    ACT_TESTCASE_DELETE(pTCase);
}

static void testASSERT_EQUAL_INT(void)
{
    ITestCase* pTCase;
    ACT_TESTCASE_NEW(pTCase,"assert_equal_int",NULL,NULL,assert_equal_int_runTest);
	
    verify(pTCase);

    ACT_TESTCASE_DELETE(pTCase);
}

static void testASSERT_NULL(void)
{
    ITestCase* pTCase;
    ACT_TESTCASE_NEW(pTCase,"assert_null",NULL,NULL,assert_null_runTest);

	verify(pTCase);

    ACT_TESTCASE_DELETE(pTCase);
}

static void testASSERT_NOT_NULL(void)
{
    ITestCase* pTCase;
    ACT_TESTCASE_NEW(pTCase,"assert_not_null",NULL,NULL,assert_not_null_runTest);

	verify(pTCase);

    ACT_TESTCASE_DELETE(pTCase);
}

static void testASSERT_MESSAGE(void)
{
    ITestCase* pTCase;
    ACT_TESTCASE_NEW(pTCase,"assert_message",NULL,NULL,assert_message_runTest);

	verify(pTCase);

    ACT_TESTCASE_DELETE(pTCase);
}

static void testASSERT(void)
{	
    ITestCase* pTCase;
    ACT_TESTCASE_NEW(pTCase,"assert",NULL,NULL,assert_runTest);

    verify(pTCase);
    
    ACT_TESTCASE_DELETE(pTCase);
}



ITest* AssertTest_tests(void)
{
    ITestCaller* pAssertTest;

    ACT_TESTCALLER_NEW(pAssertTest, "actAssertTest", setUp, tearDown);
    
    ACT_ADD_FIXTURE(pAssertTest, "testASSERT_EQUAL_STRING", testASSERT_EQUAL_STRING);
    ACT_ADD_FIXTURE(pAssertTest, "testASSERT_EQUAL_INT",testASSERT_EQUAL_INT);
    ACT_ADD_FIXTURE(pAssertTest, "testASSERT_NULL",testASSERT_NULL);
    ACT_ADD_FIXTURE(pAssertTest, "testASSERT_NOT_NULL",testASSERT_NOT_NULL);
    ACT_ADD_FIXTURE(pAssertTest, "testASSERT_MESSAGE",testASSERT_MESSAGE);
    ACT_ADD_FIXTURE(pAssertTest, "testASSERT",testASSERT);
    
    return (ITest*)pAssertTest;
}

#endif //def ACT_ASSERT_TESTS
