/*
* Advanced CUnit Test - ACT version 0.5.55
* Copyright (C)  2004 Seo, Won Ho. All rights reserved.
*
* This file is a part of the Advanced CUnit Test.
* The use and distribution terms for this software are covered by the
* Common Public License 1.0 (http://opensource.org/licenses/cpl.php)
* which can be found in the file CPL.TXT at the root of this distribution.
* By using this software in any fashion, you are agreeing to be bound by
* the terms of this license. You must not remove this notice, or
* any other, from this software.
*/

#include "act.h"
#include "actTests.h"

#ifdef ACT_STDLIB_TESTS

static void setUp(void)
{
}

static void tearDown(void)
{
}

static void teststrcpy(void)
{
	char buf[32];
	char *p;

	p = act_strcpy(buf, "test");
	ACT_TEST_ASSERT_EQUAL_STRING("test", buf);
	ACT_TEST_ASSERT( p == buf );
}

static void teststrncpy(void)
{
	char buf[32];
	char *p;

	p = act_strncpy(buf, "test", 8);
	ACT_TEST_ASSERT( buf[0]=='t' );
	ACT_TEST_ASSERT( buf[1]=='e' );
	ACT_TEST_ASSERT( buf[2]=='s' );
	ACT_TEST_ASSERT( buf[3]=='t' );
	ACT_TEST_ASSERT( buf[4]=='\0' );
	ACT_TEST_ASSERT( buf[5]=='\0' );
	ACT_TEST_ASSERT( buf[6]=='\0' );
	ACT_TEST_ASSERT( buf[7]=='\0' );
	
	p = act_strncpy(buf, "", 4);
	ACT_TEST_ASSERT( buf[0]=='\0' );
	ACT_TEST_ASSERT( buf[1]=='\0' );
	ACT_TEST_ASSERT( buf[2]=='\0' );
	ACT_TEST_ASSERT( buf[3]=='\0' );

	act_strcpy(buf, "_xxxx_");
	p = act_strncpy(buf+1, "test", 4);
	ACT_TEST_ASSERT( buf[0]=='_' );
	ACT_TEST_ASSERT( buf[1]=='t' );
	ACT_TEST_ASSERT( buf[2]=='e' );
	ACT_TEST_ASSERT( buf[3]=='s' );
	ACT_TEST_ASSERT( buf[4]=='t' );
	ACT_TEST_ASSERT( buf[5]=='_' );
	ACT_TEST_ASSERT( buf[6]=='\0' );
}

static void teststrcat(void)
{
	char buf[64];

	act_strcpy(buf,"sample");
	act_strcat(buf," extra string");
	ACT_TEST_ASSERT_EQUAL_STRING("sample extra string", buf);

	act_strcpy(buf,"");
	act_strcat(buf,"sample");
	ACT_TEST_ASSERT_EQUAL_STRING("sample", buf);
}

static void teststrncat(void)
{
	char buf[64];

	act_strcpy(buf,"sample");
	act_strncat(buf," extra string",13);
	ACT_TEST_ASSERT_EQUAL_STRING("sample extra string", buf);

	act_strcpy(buf,"This is the initial string!");
	act_strncat(buf," extra text to add to the string", 19);
	ACT_TEST_ASSERT_EQUAL_STRING("This is the initial string! extra text to add ", buf);
}

static void teststrlen(void)
{
	ACT_TEST_ASSERT( act_strlen("test")==4 );
	ACT_TEST_ASSERT( act_strlen("")==0 );
}

static void teststrcmp(void)
{
	ACT_TEST_ASSERT( act_strcmp("aaa","aaa") == 0 );
	ACT_TEST_ASSERT( act_strcmp("aaa","bbb") != 0 );
	ACT_TEST_ASSERT( act_strcmp("aaa","AAA") != 0 );
	ACT_TEST_ASSERT( act_strcmp("Test","TestCase") != 0 );
	ACT_TEST_ASSERT( act_strcmp("TestCase","Test") != 0 );
	ACT_TEST_ASSERT( act_strcmp("","") == 0 );
}

static void testitoa(void)
{
	char buf[33];
	char *p;

	p = act_itoa(10, buf, 2);
	ACT_TEST_ASSERT_EQUAL_STRING("1010", buf);
	ACT_TEST_ASSERT(p == buf);

	p = act_itoa(10, buf, 8);
	ACT_TEST_ASSERT_EQUAL_STRING("12", buf);
	ACT_TEST_ASSERT(p == buf);

	p = act_itoa(10, buf, 10);
	ACT_TEST_ASSERT_EQUAL_STRING("10", buf);
	ACT_TEST_ASSERT(p == buf);

	p = act_itoa(10, buf, 16);
	ACT_TEST_ASSERT_EQUAL_STRING("a", buf);
	ACT_TEST_ASSERT(p == buf);

	p = act_itoa(-10, buf, 2);
	ACT_TEST_ASSERT_EQUAL_STRING("11111111111111111111111111110110", buf);
	ACT_TEST_ASSERT(p == buf);

	p = act_itoa(-10, buf, 8);
	ACT_TEST_ASSERT_EQUAL_STRING("37777777766", buf);
	ACT_TEST_ASSERT(p == buf);

	p = act_itoa(-10, buf, 10);
	ACT_TEST_ASSERT_EQUAL_STRING("-10", buf);
	ACT_TEST_ASSERT(p == buf);

	p = act_itoa(-10, buf, 16);
	ACT_TEST_ASSERT_EQUAL_STRING("fffffff6", buf);
	ACT_TEST_ASSERT(p == buf);
}

static void testmemcmp(void)
{
	ACT_TEST_ASSERT(act_memcmp("sample","sample",6) == 0);
	ACT_TEST_ASSERT(act_memcmp("sample","SAMPLE",6) != 0);
	ACT_TEST_ASSERT(act_memcmp("sample","sample",0) == 0);
	ACT_TEST_ASSERT(act_memcmp("sample","samPLE",3) == 0);
}

ITest* StdLibTest_tests(void)
{
    ITestCaller* pStdLibTest;
    ACT_TESTCALLER_NEW(pStdLibTest, "actStdLibTest",setUp,tearDown)

    ACT_ADD_FIXTURE(pStdLibTest,"teststrcpy",teststrcpy);
    ACT_ADD_FIXTURE(pStdLibTest,"teststrncpy",teststrncpy);
    ACT_ADD_FIXTURE(pStdLibTest, "teststrcat",teststrcat);
    ACT_ADD_FIXTURE(pStdLibTest, "teststrncat",teststrncat);
    ACT_ADD_FIXTURE(pStdLibTest, "teststrlen",teststrlen);
    ACT_ADD_FIXTURE(pStdLibTest, "teststrcmp",teststrcmp);
    ACT_ADD_FIXTURE(pStdLibTest, "testitoa",testitoa);
    ACT_ADD_FIXTURE(pStdLibTest, "testmemcmp",testitoa);

	return (ITest*)pStdLibTest;
}

#endif // #ifdef ACT_STDLIB_TESTS

