//////////////////////////////////////////////////////////////////////
//
// Screen.h: interface for the CScreen class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SCREEN_H__ACC50F7A_96E5_40B5_B189_3FCFE88BAEB1__INCLUDED_)
#define AFX_SCREEN_H__ACC50F7A_96E5_40B5_B189_3FCFE88BAEB1__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define CLR80VID	0xC00C
#define SET80VID	0xC00D

#define TXTCLR		0xC050
#define TXTSET		0xC051
#define MIXCLR		0xC052
#define MIXSET		0xC053
#define LOWSCR		0xC054
#define	HISCR		0xC055
#define LOWRES		0xC056
#define HIRES		0xC057
#define CLRAN0		0xC058
#define SETAN0		0xC059
#define CLRAN1		0xC05A
#define SETAN1		0xC05B
#define CLRAN2		0xC05C
#define SETAN2		0xC05D
#define CLRAN3		0xC05E
#define SETDHIRES	0xC05E
#define SETAN3		0xC05F
#define CLRDHIRES	0xC05F

#define	TAPEIN		0xC060
#define	BUTN0		0xC061
#define	BUTN1		0xC062
#define	BUTN2		0xC063
#define PADDL0		0xC064
#define PADDL1		0xC065
#define PADDL2		0xC066
#define PADDL3		0xC067

#define PTRIG           0xC070
#define SETIOUDIS	0xC07E
#define RDIOUDIS        0xC07E
#define CLRIOUDIS	0xC07F
#define RDDHIRES	0xC07F

#define CLRROM		0xCFFF

/* LSB are graphics switches */
#define SS_MIXED	(1<<0)
#define SS_TEXT		(1<<1)
#define SS_PAGE2	(1<<2)
#define SS_80COL	(1<<3)
#define SS_HIRES	(1<<4)

#define SS_80STORE	(1<<5)
#define SS_DHIRES	(1<<6)
#define IOU_VIDEO_SS_MASK	(0x7f)

#define SS_ALTCHAR	(1<<7)
#define SS_RAMRD	(1<<8)
#define SS_RAMWRT	(1<<9)
#define SS_SLOTCXROM	(1<<10)
#define SS_ALTZP	(1<<11)
#define SS_SLOTC3ROM	(1<<12)
#define SS_IOUDIS	(1<<13)
#define SS_LCBNK2	(1<<14)
#define SS_LCRAMRD	(1<<15)
#define SS_LCRAM	SS_LCRAMRD
#define SS_LCRAMWRT	(1<<16)
//#define SS_VBLBAR	(1<<17)
#define SS_EXPNROM	(1<<18)		/* 80 column ROM $C800-$CFFF active */

#define SS_AN0		(1<<19)
#define SS_AN1		(1<<20)
#define SS_AN2		(1<<21)
#define SS_AN3		(1<<22)

//#define SS_VBL		(1<<23)

#define SM_COLOR	0
#define SM_COLOR2	1
#define SM_WHITE	2
#define SM_GREEN	3

#define WIN_WIDTH	576
#define WIN_HEIGHT	392

#define FULL_WIDTH	640
#define FULL_HEIGHT	480
#define FULL_BPP	16

#define DISK_VIEW_WIDTH 72
#define DISK_VIEW_HEIGHT 16
#define MSG_VIEW_WIDTH 400
#define MSG_VIEW_HEIGHT 16

#include <ddraw.h>
#include "arch/directx/ddutil.h"
#include "lockmgr.h"

class CAppleClock;

class CScreen : public CWnd
{
public:
	CSurface* m_pSurfaceDisk;
	CSurface* m_pSurfaceMsg;

	BOOL m_bWindowed;
	CDisplay* m_pDisplay;
	BYTE m_aiScreenTable[0x2000][2];
	WORD m_awScanOT[192];
	BYTE* m_apbScanAT[8][192];
	COLORREF m_crAppleColor[16];
	COLORREF m_crAppleColor2[16];
	int m_iScrMode;
	int m_aScanLine[192];
	BYTE m_pixelInfo[2][192][WIN_WIDTH];
	CCSWrapper m_Lock;

public:
	int m_iBlinkCount;
	CScreen( );
	virtual ~CScreen();

	void Redraw();
	void OnDebug();
	HRESULT Present();
	char* DDErrorString(HRESULT hr);
	BYTE ChangeMode(WORD addr);
	void ReInitialize();
protected:
	DDSURFACEDESC m_ddsdDesc;
	LPDIRECTDRAWSURFACE m_lpddsPrimary;
	LPDIRECTDRAW m_lpddDraw;
	int m_iGreenColor;
	int m_iWhiteColor;
	BYTE m_nVideoMode;
//	BOOL m_bInitializing;
	BOOL m_nMsgVisiable;

	TCHAR* m_szMessage;
	HFONT m_hFont;
//functions
protected:
	BOOL InitDirectX();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CScreen)
	public:
	//}}AFX_VIRTUAL

protected:
	POINT m_stWindowPos;
	int m_iColorDepth;
	DWORD m_nTime;
	unsigned int m_iFrameCount;
	BOOL m_bPowerOn;
	unsigned int m_nHSB;
	//{{AFX_MSG(CScreen)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnPaint();
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMove(int x, int y);
	afx_msg LRESULT OnDisplayChanged(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnDisplayChange(WPARAM wParam, LPARAM lParam);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

public:
	void HideMessage();
	void ToggleMessage();
	void SetMessage(TCHAR* szText);
	void UpdateDiskSurface();
	CSurface* GetDiskSurface();
	void SetFullScreenMode(BOOL bFullScreen);
	void Reset();
	COLORREF ApplyRGBFormat( COLORREF rgb32, LPDDPIXELFORMAT DDpf );
	void Clr80Store();
	void Set80Store();
	BYTE CheckMode( WORD addr );
	unsigned int GetHSB();
	void SetHSB(int hue, BYTE saturation, BYTE bright);
	unsigned int ColorCompose(unsigned int c1, unsigned int c2);
	// h: 0~0xFF, s:0~0xFF, b:0~0xFF
	unsigned int HSB2RGB(int h, BYTE s, BYTE b);
	// hsb:0~0xFFFFFF
	unsigned int HSB2RGB(unsigned int hsb);
	void ChangeMonitorType();
	void ChangeMonitorType(int type);
	int GetMonitorType();
	void RedrawAll();
	BYTE m_abPosTable[120];
	void setLookUp(BYTE *pMemory);

	void writeMemory(WORD addr, BYTE data, BOOL aux);
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SCREEN_H__ACC50F7A_96E5_40B5_B189_3FCFE88BAEB1__INCLUDED_)

