// Slots.h: interface for the CSlots class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SLOTS_H__3A324547_6F9B_457B_8806_63D948497F5F__INCLUDED_)
#define AFX_SLOTS_H__3A324547_6F9B_457B_8806_63D948497F5F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define MAX_SLOTS	7

#include "card.h"

class CSlots
{
public:
	void SetDipSwitch(int nSlot, int nDipSwitch);
	BOOL InsertCard(int nSlot, int nDeviceNum);
	BOOL InsertCard(int nSlot, CCard* pCard);
	void RemoveCard( int nSlot );
	CCard* GetCard( int slot );
	void Clock( DWORD clock );
	void Reset();
	void Write( WORD addr, BYTE data );
	void WriteRom( WORD addr, BYTE data );
	BYTE ReadRom( WORD addr );
	void PowerOff();
	BYTE Read( WORD addr );
	void PowerOn();
	BOOL Initialize();
	CSlots();
	virtual ~CSlots();

protected:
	CCard	*m_slots[MAX_SLOTS];	// slots
};

#endif // !defined(AFX_SLOTS_H__3A324547_6F9B_457B_8806_63D948497F5F__INCLUDED_)
