// DlgConfigSound.cpp : implementation file
//

#include "arch/frame/stdafx.h"
#include "arch/frame/aipc.h"
#include "arch/frame/dlgconfigsound.h"
#include "appleclock.h"
#include "arch/directx/dxsound.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CAppleClock *g_pBoard;
/////////////////////////////////////////////////////////////////////////////
// CDlgConfigSound dialog


CDlgConfigSound::CDlgConfigSound(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgConfigSound::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgConfigSound)
	m_nSampleRate = 2;
	m_bMasterMute = FALSE;
	m_bSpeakerMute = FALSE;
	//}}AFX_DATA_INIT
}


void CDlgConfigSound::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgConfigSound)
	DDX_Control(pDX, IDC_SPEAKER_VOLUME, m_scSpeakerVol);
	DDX_Control(pDX, IDC_MASTER_VOLUME, m_scMasterVol);
	DDX_CBIndex(pDX, IDC_SAMPLE_RATE, m_nSampleRate);
	DDX_Check(pDX, IDC_MASTER_MUTE, m_bMasterMute);
	DDX_Check(pDX, IDC_SPEAKER_MUTE, m_bSpeakerMute);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDlgConfigSound, CDialog)
	//{{AFX_MSG_MAP(CDlgConfigSound)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgConfigSound message handlers

BOOL CDlgConfigSound::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_scMasterVol.SetRange( 0, 31, FALSE );
	m_scMasterVol.SetTicFreq(8);
	m_scMasterVol.SetPageSize(2);
	m_scMasterVol.SetPos( 31 - g_DXSound.m_iVol );
	m_scSpeakerVol.SetRange( 0, 31, FALSE );
	m_scSpeakerVol.SetTicFreq(8);
	m_scSpeakerVol.SetPageSize(2);
	m_scSpeakerVol.SetPos( 31 - g_pBoard->m_cSpeaker.m_iVol );
	switch( g_DXSound.m_nSampleRate )
	{
	case 11025:
		m_nSampleRate = 0;
		break;
	case 22050:
		m_nSampleRate = 1;
		break;
	case 44100:
		m_nSampleRate = 2;
		break;
	}
	m_bMasterMute = g_DXSound.m_bMute;
	m_bSpeakerMute = g_pBoard->m_cSpeaker.m_bMute;
	UpdateData(FALSE);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CDlgConfigSound::OnOK() 
{
	// TODO: Add extra validation here
	UpdateData(TRUE);

	g_pBoard->m_cSpeaker.SetVolume( 31 - m_scSpeakerVol.GetPos() );
	g_DXSound.SetVolume( 31 - m_scMasterVol.GetPos() );
	static int rates[3] = { 11025, 22050, 44100 };
	g_DXSound.m_bMute = m_bMasterMute;
	g_pBoard->m_cSpeaker.m_bMute = m_bSpeakerMute;
	g_DXSound.ChangeSampleRate( rates[m_nSampleRate] );
	CDialog::OnOK();
}
