/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.bindings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.commands.contexts.ContextManagerEvent;
import org.eclipse.core.commands.contexts.IContextManagerListener;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.BindingManagerEvent;
import org.eclipse.jface.bindings.CachedBindingSet;
import org.eclipse.jface.bindings.IBindingManagerListener;
import org.eclipse.jface.bindings.ISchemeListener;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.jface.bindings.SchemeEvent;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.SWT;

public final class BindingManager
implements IContextManagerListener,
ISchemeListener {
    public static boolean DEBUG = false;
    private static final String LOCALE_SEPARATOR = "_";
    private Map activeBindings = null;
    private Map activeBindingsByCommandId = null;
    private Scheme activeScheme = null;
    private String[] activeSchemeIds = null;
    private int bindingCount = 0;
    private Binding[] bindings = null;
    private Map cachedBindings = new HashMap();
    private final ContextManager contextManager;
    private final Set definedSchemeIds = new HashSet();
    private Collection listeners = null;
    private String locale = Locale.getDefault().toString();
    private String[] locales = BindingManager.expand(this.locale, "_");
    private String platform = SWT.getPlatform();
    private String[] platforms = BindingManager.expand(this.platform, "");
    private Map prefixTable = null;
    private final Map schemesById = new HashMap();

    private static final void addReverseLookup(Map map, Object key, Object value) {
        if (map == null) {
            return;
        }
        Object currentValue = map.get(key);
        if (currentValue != null) {
            Collection values = (Collection)currentValue;
            values.add(value);
        } else {
            ArrayList<Object> values = new ArrayList<Object>(1);
            values.add(value);
            map.put(key, values);
        }
    }

    private static final String[] expand(String string, String separator) {
        if (string == null || separator == null) {
            return new String[0];
        }
        ArrayList<String> strings = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        if ((string = string.trim()).length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, separator);
            while (stringTokenizer.hasMoreElements()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(separator);
                }
                stringBuffer.append(((String)stringTokenizer.nextElement()).trim());
                strings.add(stringBuffer.toString());
            }
        }
        Collections.reverse(strings);
        strings.add("");
        strings.add(null);
        return strings.toArray(new String[strings.size()]);
    }

    public BindingManager(ContextManager contextManager) {
        if (contextManager == null) {
            throw new NullPointerException("A binding manager requires a context manager");
        }
        this.contextManager = contextManager;
        contextManager.addContextManagerListener((IContextManagerListener)this);
    }

    public final void addBinding(Binding binding) {
        if (binding == null) {
            throw new NullPointerException("Cannot add a null binding");
        }
        if (this.bindings == null) {
            this.bindings = new Binding[1];
        } else if (this.bindingCount >= this.bindings.length) {
            Binding[] oldBindings = this.bindings;
            this.bindings = new Binding[oldBindings.length * 2];
            System.arraycopy(oldBindings, 0, this.bindings, 0, oldBindings.length);
        }
        this.bindings[this.bindingCount++] = binding;
        this.clearCache();
    }

    public final void addBindingManagerListener(IBindingManagerListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        this.listeners.add(listener);
    }

    private final Map buildPrefixTable(Map activeBindings) {
        HashMap prefixTable = new HashMap();
        Iterator bindingItr = activeBindings.entrySet().iterator();
        while (bindingItr.hasNext()) {
            List prefixes;
            Map.Entry entry = bindingItr.next();
            TriggerSequence triggerSequence = (TriggerSequence)entry.getKey();
            if (!prefixTable.containsKey(triggerSequence)) {
                prefixTable.put(triggerSequence, null);
            }
            if ((prefixes = triggerSequence.getPrefixes()).isEmpty()) continue;
            String commandId = (String)entry.getValue();
            Iterator prefixItr = prefixes.iterator();
            while (prefixItr.hasNext()) {
                TriggerSequence prefix = (TriggerSequence)prefixItr.next();
                Object value = prefixTable.get(prefix);
                if (prefixTable.containsKey(prefix) && value instanceof Map) {
                    ((Map)value).put(triggerSequence, commandId);
                    continue;
                }
                HashMap<TriggerSequence, String> map = new HashMap<TriggerSequence, String>();
                prefixTable.put(prefix, map);
                map.put(triggerSequence, commandId);
            }
        }
        return prefixTable;
    }

    private final void clearCache() {
        if (DEBUG) {
            System.out.println("BINDINGS >> Clearing cache");
        }
        this.cachedBindings.clear();
        this.clearSolution();
    }

    private final void clearSolution() {
        this.setActiveBindings(null, null, null);
    }

    private final void computeBindings(Map activeContextTree, Map commandIdsByTrigger, Map triggersByCommandId) {
        Binding[] trimmedBindings = this.removeDeletions(this.bindings);
        HashMap<TriggerSequence, Object> possibleBindings = new HashMap<TriggerSequence, Object>();
        int length = trimmedBindings.length;
        int i = 0;
        while (i < length) {
            Binding binding = trimmedBindings[i];
            String contextId = binding.getContextId();
            if ((activeContextTree == null || activeContextTree.containsKey(contextId)) && this.localeMatches(binding) && this.platformMatches(binding)) {
                String schemeId = binding.getSchemeId();
                boolean found = false;
                int j = 0;
                while (j < this.activeSchemeIds.length) {
                    if (Util.equals(schemeId, this.activeSchemeIds[j])) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (found) {
                    ArrayList<Binding> matches;
                    TriggerSequence trigger = binding.getTriggerSequence();
                    Object existingMatch = possibleBindings.get(trigger);
                    if (existingMatch instanceof Binding) {
                        possibleBindings.remove(trigger);
                        matches = new ArrayList<Binding>();
                        matches.add((Binding)existingMatch);
                        matches.add(binding);
                        possibleBindings.put(trigger, matches);
                    } else if (existingMatch instanceof Collection) {
                        matches = (ArrayList<Binding>)existingMatch;
                        matches.add(binding);
                    } else {
                        possibleBindings.put(trigger, binding);
                    }
                }
            }
            ++i;
        }
        Iterator possibleBindingItr = possibleBindings.entrySet().iterator();
        while (possibleBindingItr.hasNext()) {
            Map.Entry entry = possibleBindingItr.next();
            TriggerSequence trigger = (TriggerSequence)entry.getKey();
            Object match = entry.getValue();
            if (activeContextTree == null) {
                ArrayList bindings = new ArrayList();
                if (match instanceof Binding) {
                    bindings.add(match);
                    commandIdsByTrigger.put(trigger, bindings);
                    BindingManager.addReverseLookup(triggersByCommandId, ((Binding)match).getCommandId(), trigger);
                    continue;
                }
                if (!(match instanceof Collection)) continue;
                bindings.addAll(this.resolveConflicts((Collection)match));
                commandIdsByTrigger.put(trigger, bindings);
                Iterator matchItr = bindings.iterator();
                while (matchItr.hasNext()) {
                    BindingManager.addReverseLookup(triggersByCommandId, ((Binding)matchItr.next()).getCommandId(), trigger);
                }
                continue;
            }
            if (match instanceof Binding) {
                String commandId = ((Binding)match).getCommandId();
                commandIdsByTrigger.put(trigger, commandId);
                BindingManager.addReverseLookup(triggersByCommandId, commandId, trigger);
                continue;
            }
            if (!(match instanceof Collection)) continue;
            Binding winner = this.resolveConflicts((Collection)match, activeContextTree);
            if (winner == null) {
                if (!DEBUG) continue;
                System.out.println("BINDINGS >> A conflict occurred for " + trigger);
                System.out.println("BINDINGS >>     " + match);
                continue;
            }
            String commandId = winner.getCommandId();
            commandIdsByTrigger.put(trigger, commandId);
            BindingManager.addReverseLookup(triggersByCommandId, commandId, trigger);
        }
    }

    public final void contextManagerChanged(ContextManagerEvent contextManagerEvent) {
        if (contextManagerEvent.haveActiveContextsChanged()) {
            this.clearSolution();
        }
    }

    private final Map createContextTreeFor(Set contextIds) {
        HashMap<String, String> contextTree = new HashMap<String, String>();
        Iterator contextIdItr = contextIds.iterator();
        block2: while (contextIdItr.hasNext()) {
            String childContextId = (String)contextIdItr.next();
            while (childContextId != null) {
                Context childContext = this.contextManager.getContext(childContextId);
                try {
                    String parentContextId = childContext.getParentId();
                    contextTree.put(childContextId, parentContextId);
                    childContextId = parentContextId;
                }
                catch (NotDefinedException notDefinedException) {
                    continue block2;
                }
            }
        }
        return contextTree;
    }

    private final Map createFilteredContextTreeFor(Set contextIds) {
        block9: {
            String contextId;
            boolean dialog = false;
            boolean window = false;
            Iterator contextIdItr = contextIds.iterator();
            while (contextIdItr.hasNext()) {
                contextId = (String)contextIdItr.next();
                if ("org.eclipse.ui.contexts.dialog".equals(contextId)) {
                    dialog = true;
                    continue;
                }
                if (!"org.eclipse.ui.contexts.window".equals(contextId)) continue;
                window = true;
            }
            try {
                contextIdItr = contextIds.iterator();
                block3: while (contextIdItr.hasNext()) {
                    contextId = (String)contextIdItr.next();
                    Context context = this.contextManager.getContext(contextId);
                    String parentId = context.getParentId();
                    while (parentId != null) {
                        if ("org.eclipse.ui.contexts.dialog".equals(parentId)) {
                            if (dialog) continue block3;
                            contextIdItr.remove();
                            continue block3;
                        }
                        if ("org.eclipse.ui.contexts.window".equals(parentId)) {
                            if (window) continue block3;
                            contextIdItr.remove();
                            continue block3;
                        }
                        if ("org.eclipse.ui.contexts.dialogAndWindow".equals(parentId)) {
                            if (window || dialog) continue block3;
                            contextIdItr.remove();
                            continue block3;
                        }
                        context = this.contextManager.getContext(parentId);
                        parentId = context.getParentId();
                    }
                }
            }
            catch (NotDefinedException e) {
                if (!DEBUG) break block9;
                System.out.println("BINDINGS >>> NotDefinedException('" + e.getMessage() + "') while filtering dialog/window contexts");
            }
        }
        return this.createContextTreeFor(contextIds);
    }

    private final void fireBindingManagerChanged(BindingManagerEvent event) {
        if (event == null) {
            throw new NullPointerException();
        }
        if (this.listeners != null) {
            Iterator listenerItr = this.listeners.iterator();
            while (listenerItr.hasNext()) {
                IBindingManagerListener listener = (IBindingManagerListener)listenerItr.next();
                listener.bindingManagerChanged(event);
            }
        }
    }

    private final Map getActiveBindings() {
        if (this.activeBindings == null) {
            this.recomputeBindings();
        }
        return Collections.unmodifiableMap(this.activeBindings);
    }

    private final Map getActiveBindingsByCommandId() {
        if (this.activeBindingsByCommandId == null) {
            this.recomputeBindings();
        }
        return Collections.unmodifiableMap(this.activeBindingsByCommandId);
    }

    public final Map getActiveBindingsDisregardingContext() {
        HashMap commandIdsByTrigger;
        if (this.bindings == null) {
            return Collections.EMPTY_MAP;
        }
        CachedBindingSet bindingCache = new CachedBindingSet(null, this.locales, this.platforms, this.activeSchemeIds);
        CachedBindingSet existingCache = (CachedBindingSet)this.cachedBindings.get(bindingCache);
        if (existingCache == null) {
            existingCache = bindingCache;
            this.cachedBindings.put(existingCache, existingCache);
        }
        if ((commandIdsByTrigger = existingCache.getCommandIdsByTrigger()) != null) {
            if (DEBUG) {
                System.out.println("BINDINGS >> Cache hit");
            }
            return Collections.unmodifiableMap(commandIdsByTrigger);
        }
        if (DEBUG) {
            System.out.println("BINDINGS >> Cache miss");
        }
        commandIdsByTrigger = new HashMap();
        this.computeBindings(null, commandIdsByTrigger, null);
        existingCache.setCommandIdsByTrigger(commandIdsByTrigger);
        return Collections.unmodifiableMap(commandIdsByTrigger);
    }

    public final Collection getActiveBindingsDisregardingContextFlat() {
        Collection bindingCollections = this.getActiveBindingsDisregardingContext().values();
        ArrayList mergedBindings = new ArrayList();
        Iterator bindingCollectionItr = bindingCollections.iterator();
        while (bindingCollectionItr.hasNext()) {
            Collection bindingCollection = (Collection)bindingCollectionItr.next();
            if (bindingCollection == null || bindingCollection.isEmpty()) continue;
            mergedBindings.addAll(bindingCollection);
        }
        return mergedBindings;
    }

    public final Collection getActiveBindingsFor(String commandId) {
        Object object = this.getActiveBindingsByCommandId().get(commandId);
        if (object instanceof Collection) {
            return (Collection)object;
        }
        return Collections.EMPTY_LIST;
    }

    public final Scheme getActiveScheme() {
        return this.activeScheme;
    }

    public final Set getBindings() {
        if (this.bindings == null) {
            return null;
        }
        HashSet<Binding> returnValue = new HashSet<Binding>();
        int i = 0;
        while (i < this.bindingCount) {
            returnValue.add(this.bindings[i]);
            ++i;
        }
        return returnValue;
    }

    public final Set getDefinedSchemeIds() {
        return Collections.unmodifiableSet(this.definedSchemeIds);
    }

    public final String getLocale() {
        return this.locale;
    }

    public final Map getPartialMatches(TriggerSequence trigger) {
        Map partialMatches = (Map)this.getPrefixTable().get(trigger);
        if (partialMatches == null) {
            return Collections.EMPTY_MAP;
        }
        return partialMatches;
    }

    public final String getPerfectMatch(TriggerSequence trigger) {
        return (String)this.getActiveBindings().get(trigger);
    }

    public final String getPlatform() {
        return this.platform;
    }

    private final Map getPrefixTable() {
        if (this.prefixTable == null) {
            this.recomputeBindings();
        }
        return Collections.unmodifiableMap(this.prefixTable);
    }

    public final Scheme getScheme(String identifier) {
        if (identifier == null) {
            throw new NullPointerException("Cannot get a scheme with a null identifier");
        }
        Scheme scheme = (Scheme)this.schemesById.get(identifier);
        if (scheme == null) {
            scheme = new Scheme(identifier);
            this.schemesById.put(identifier, scheme);
            scheme.addSchemeListener(this);
        }
        return scheme;
    }

    private final String[] getSchemeIds(String schemeId) {
        ArrayList<String> strings = new ArrayList<String>();
        while (schemeId != null) {
            strings.add(schemeId);
            try {
                schemeId = this.getScheme(schemeId).getParentId();
            }
            catch (NotDefinedException notDefinedException) {
                return new String[0];
            }
        }
        return strings.toArray(new String[strings.size()]);
    }

    public final boolean isPartialMatch(TriggerSequence trigger) {
        return this.getPrefixTable().get(trigger) != null;
    }

    public final boolean isPerfectMatch(TriggerSequence trigger) {
        return this.getActiveBindings().containsKey(trigger);
    }

    private final boolean localeMatches(Binding binding) {
        boolean matches = false;
        String locale = binding.getLocale();
        if (locale == null) {
            return true;
        }
        int i = 0;
        while (i < this.locales.length) {
            if (Util.equals(this.locales[i], locale)) {
                matches = true;
                break;
            }
            ++i;
        }
        return matches;
    }

    private final boolean platformMatches(Binding binding) {
        boolean matches = false;
        String platform = binding.getPlatform();
        if (platform == null) {
            return true;
        }
        int i = 0;
        while (i < this.platforms.length) {
            if (Util.equals(this.platforms[i], platform)) {
                matches = true;
                break;
            }
            ++i;
        }
        return matches;
    }

    private final void recomputeBindings() {
        HashMap commandIdsByTrigger;
        if (this.bindings == null) {
            this.setActiveBindings(Collections.EMPTY_MAP, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
            return;
        }
        HashSet activeContextIds = new HashSet(this.contextManager.getActiveContextIds());
        Map activeContextTree = this.createFilteredContextTreeFor(activeContextIds);
        CachedBindingSet bindingCache = new CachedBindingSet(activeContextTree, this.locales, this.platforms, this.activeSchemeIds);
        CachedBindingSet existingCache = (CachedBindingSet)this.cachedBindings.get(bindingCache);
        if (existingCache == null) {
            existingCache = bindingCache;
            this.cachedBindings.put(existingCache, existingCache);
        }
        if ((commandIdsByTrigger = existingCache.getCommandIdsByTrigger()) != null) {
            if (DEBUG) {
                System.out.println("BINDINGS >> Cache hit");
            }
            this.setActiveBindings(commandIdsByTrigger, existingCache.getTriggersByCommandId(), existingCache.getPrefixTable());
            return;
        }
        if (DEBUG) {
            System.out.println("BINDINGS >> Cache miss");
        }
        commandIdsByTrigger = new HashMap();
        HashMap triggersByCommandId = new HashMap();
        this.computeBindings(activeContextTree, commandIdsByTrigger, triggersByCommandId);
        existingCache.setCommandIdsByTrigger(commandIdsByTrigger);
        existingCache.setTriggersByCommandId(triggersByCommandId);
        this.setActiveBindings(commandIdsByTrigger, triggersByCommandId, this.buildPrefixTable(commandIdsByTrigger));
        existingCache.setPrefixTable(this.prefixTable);
    }

    public final void removeBindingManagerListener(IBindingManagerListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    public final void removeBindings(TriggerSequence sequence, String schemeId, String contextId, String locale, String platform, String windowManager, int type) {
        if (this.bindings == null || this.bindingCount < 1) {
            return;
        }
        Binding[] newBindings = new Binding[this.bindings.length];
        boolean bindingsChanged = false;
        int index = 0;
        int i = 0;
        while (i < this.bindingCount) {
            Binding binding = this.bindings[i];
            boolean equals = true;
            equals &= Util.equals(sequence, binding.getTriggerSequence());
            equals &= Util.equals(schemeId, binding.getSchemeId());
            equals &= Util.equals(contextId, binding.getContextId());
            equals &= Util.equals(locale, binding.getLocale());
            equals &= Util.equals(platform, binding.getPlatform());
            if (equals &= type == binding.getType()) {
                bindingsChanged = true;
            } else {
                newBindings[index++] = binding;
            }
            ++i;
        }
        if (bindingsChanged) {
            this.bindings = newBindings;
            this.bindingCount = index;
            this.clearCache();
        }
    }

    private final Binding[] removeDeletions(Binding[] bindings) {
        Binding binding;
        HashMap<TriggerSequence, Binding> deletions = new HashMap<TriggerSequence, Binding>();
        Binding[] bindingsCopy = new Binding[this.bindingCount];
        System.arraycopy(bindings, 0, bindingsCopy, 0, this.bindingCount);
        int deletedCount = 0;
        int i = 0;
        while (i < this.bindingCount) {
            binding = bindingsCopy[i];
            if (binding.getCommandId() == null && this.localeMatches(binding) && this.platformMatches(binding)) {
                deletions.put(binding.getTriggerSequence(), binding);
                bindingsCopy[i] = null;
                ++deletedCount;
            }
            ++i;
        }
        if (DEBUG) {
            System.out.println("BINDINGS >> There are " + deletions.size() + " deletion markers");
        }
        i = 0;
        while (i < this.bindingCount) {
            Object deletion;
            binding = bindingsCopy[i];
            if (binding != null && (deletion = deletions.get(binding.getTriggerSequence())) != null && ((Binding)deletion).deletes(binding)) {
                bindingsCopy[i] = null;
                ++deletedCount;
            }
            ++i;
        }
        Binding[] returnValue = new Binding[this.bindingCount - deletedCount];
        int index = 0;
        int i2 = 0;
        while (i2 < this.bindingCount) {
            Binding binding2 = bindingsCopy[i2];
            if (binding2 != null) {
                returnValue[index++] = binding2;
            }
            ++i2;
        }
        return returnValue;
    }

    private final Collection resolveConflicts(Collection bindings) {
        ArrayList<Binding> matches = new ArrayList<Binding>();
        Iterator bindingItr = bindings.iterator();
        Binding bestMatch = (Binding)bindingItr.next();
        while (bindingItr.hasNext()) {
            String bestScheme;
            Binding current = (Binding)bindingItr.next();
            String currentScheme = current.getSchemeId();
            if (!currentScheme.equals(bestScheme = bestMatch.getSchemeId())) {
                boolean goToNextBinding = false;
                int i = 0;
                while (i < this.activeSchemeIds.length) {
                    String schemePointer = this.activeSchemeIds[i];
                    if (currentScheme.equals(schemePointer)) {
                        bestMatch = current;
                        matches.clear();
                        matches.add(current);
                        goToNextBinding = true;
                        break;
                    }
                    if (bestScheme.equals(schemePointer)) {
                        goToNextBinding = true;
                        break;
                    }
                    ++i;
                }
                if (goToNextBinding) continue;
            }
            if (current.getType() > bestMatch.getType()) {
                bestMatch = current;
                matches.clear();
                matches.add(current);
                continue;
            }
            if (bestMatch.getType() > current.getType()) continue;
            matches.add(current);
        }
        return matches;
    }

    private final Binding resolveConflicts(Collection bindings, Map activeContextTree) {
        boolean conflict = false;
        Iterator bindingItr = bindings.iterator();
        Binding bestMatch = (Binding)bindingItr.next();
        while (bindingItr.hasNext()) {
            String bestScheme;
            String currentScheme;
            String bestContext;
            Binding current = (Binding)bindingItr.next();
            String currentContext = current.getContextId();
            if (!currentContext.equals(bestContext = bestMatch.getContextId())) {
                boolean goToNextBinding = false;
                String contextPointer = currentContext;
                while (contextPointer != null) {
                    if (contextPointer.equals(bestContext)) {
                        bestMatch = current;
                        conflict = false;
                        goToNextBinding = true;
                        break;
                    }
                    contextPointer = (String)activeContextTree.get(contextPointer);
                }
                contextPointer = bestContext;
                while (contextPointer != null) {
                    if (contextPointer.equals(currentContext)) {
                        goToNextBinding = true;
                        break;
                    }
                    contextPointer = (String)activeContextTree.get(contextPointer);
                }
                if (goToNextBinding) continue;
            }
            if (!(currentScheme = current.getSchemeId()).equals(bestScheme = bestMatch.getSchemeId())) {
                boolean goToNextBinding = false;
                int i = 0;
                while (i < this.activeSchemeIds.length) {
                    String schemePointer = this.activeSchemeIds[i];
                    if (currentScheme.equals(schemePointer)) {
                        bestMatch = current;
                        conflict = false;
                        goToNextBinding = true;
                        break;
                    }
                    if (bestScheme.equals(schemePointer)) {
                        goToNextBinding = true;
                        break;
                    }
                    ++i;
                }
                if (goToNextBinding) continue;
            }
            if (current.getType() > bestMatch.getType()) {
                bestMatch = current;
                conflict = false;
                continue;
            }
            if (bestMatch.getType() > current.getType()) continue;
            conflict = true;
        }
        if (conflict) {
            return null;
        }
        return bestMatch;
    }

    public final void schemeChanged(SchemeEvent schemeEvent) {
        if (schemeEvent.hasDefinedChanged()) {
            Scheme scheme = schemeEvent.getScheme();
            String schemeId = scheme.getId();
            boolean schemeIdAdded = scheme.isDefined();
            boolean activeSchemeChanged = false;
            if (schemeIdAdded) {
                this.definedSchemeIds.add(schemeId);
            } else {
                this.definedSchemeIds.remove(schemeId);
                if (this.activeScheme == scheme) {
                    this.activeScheme = null;
                    this.activeSchemeIds = null;
                    activeSchemeChanged = true;
                    this.clearSolution();
                }
            }
            this.fireBindingManagerChanged(new BindingManagerEvent(this, false, activeSchemeChanged, schemeId, schemeIdAdded, !schemeIdAdded, false, false));
        }
    }

    private final void setActiveBindings(Map activeBindings, Map activeBindingsByCommandId, Map prefixTable) {
        this.activeBindings = activeBindings;
        this.activeBindingsByCommandId = activeBindingsByCommandId;
        this.prefixTable = prefixTable;
        this.fireBindingManagerChanged(new BindingManagerEvent(this, true, false, null, false, false, false, false));
    }

    public final void setActiveScheme(Scheme scheme) throws NotDefinedException {
        if (scheme == null) {
            throw new NullPointerException("Cannot activate a null scheme");
        }
        if (scheme == null || !scheme.isDefined()) {
            throw new NotDefinedException("Cannot activate an undefined scheme");
        }
        if (Util.equals(this.activeScheme, scheme)) {
            return;
        }
        this.activeScheme = scheme;
        this.activeSchemeIds = this.getSchemeIds(this.activeScheme.getId());
        this.clearSolution();
        this.fireBindingManagerChanged(new BindingManagerEvent(this, false, true, null, false, false, false, false));
    }

    public final void setBindings(Set bindings) {
        if (Util.equals((Object)this.bindings, bindings)) {
            return;
        }
        if (bindings == null || bindings.isEmpty()) {
            this.bindings = null;
            this.bindingCount = 0;
        } else {
            this.bindings = bindings.toArray(new Binding[bindings.size()]);
            this.bindingCount = bindings.size();
        }
        this.clearCache();
    }

    public final void setLocale(String locale) {
        if (locale == null) {
            throw new NullPointerException("The locale cannot be null");
        }
        if (!Util.equals(this.locale, locale)) {
            this.locale = locale;
            this.locales = BindingManager.expand(locale, LOCALE_SEPARATOR);
            this.clearSolution();
            this.fireBindingManagerChanged(new BindingManagerEvent(this, false, false, null, false, false, true, false));
        }
    }

    public final void setPlatform(String platform) {
        if (platform == null) {
            throw new NullPointerException("The platform cannot be null");
        }
        if (!Util.equals(this.platform, platform)) {
            this.platform = platform;
            this.platforms = BindingManager.expand(platform, "");
            this.clearSolution();
            this.fireBindingManagerChanged(new BindingManagerEvent(this, false, false, null, false, false, false, true));
        }
    }
}

